/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.Random;
import org.refcodes.generator.Generator;
import org.refcodes.mixin.CharSetAccessor;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.textual.RandomTextMode;

public class RandomTextGenerartor
implements ColumnWidthAccessor.ColumnWidthBuilder<RandomTextGenerartor>,
ColumnWidthAccessor.ColumnWidthProperty,
Generator<String>,
CharSetAccessor.CharSetProperty,
CharSetAccessor.CharSetBuilder<RandomTextGenerartor> {
    private int _columnWidth = 64;
    private RandomTextMode _randomTextMode = RandomTextMode.ASCII;
    private static Random _numberGenerator = new Random();
    private char[] _charSet = null;

    public RandomTextGenerartor withColumnWidth(int n) {
        this.setColumnWidth(n);
        return this;
    }

    public void setColumnWidth(int n) {
        this._columnWidth = n;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    public boolean hasNext() {
        return true;
    }

    public String next() {
        if (this._charSet != null) {
            return RandomTextGenerartor.toRandom(this._charSet, this._columnWidth, _numberGenerator);
        }
        return RandomTextGenerartor.toRandom(this._randomTextMode.getCharSet(), this._columnWidth, _numberGenerator);
    }

    public RandomTextMode getRandomTextMode() {
        return this._randomTextMode;
    }

    public void setRandomTextMode(RandomTextMode randomTextMode) {
        this._randomTextMode = randomTextMode;
        if (randomTextMode != null) {
            this._charSet = null;
        }
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    public void setCharSet(char[] cArray) {
        this._charSet = cArray;
        if (cArray != null) {
            this._randomTextMode = null;
        }
    }

    public RandomTextGenerartor withCharSet(char[] cArray) {
        this.setCharSet(cArray);
        return this;
    }

    public RandomTextGenerartor withRandomTextMode(RandomTextMode randomTextMode) {
        this.setRandomTextMode(randomTextMode);
        return this;
    }

    public static String asString(int n, RandomTextMode randomTextMode) {
        return RandomTextGenerartor.toRandom(randomTextMode.getCharSet(), n, _numberGenerator);
    }

    public static String asString(int n) {
        return RandomTextGenerartor.toRandom(RandomTextMode.ALPHANUMERIC.getCharSet(), n, _numberGenerator);
    }

    private static String toRandom(char[] cArray, int n, Random random) {
        int n2 = cArray.length;
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = cArray[random.nextInt(n2)];
        }
        return new String(cArray2);
    }
}

