/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Encoding;
import org.refcodes.data.MarshalParameter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactory;
import org.refcodes.struct.ext.factory.DocumentProperty;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlCanonicalMapFactory
extends AbstractCanonicalMapFactory {
    protected static final String ROOT_SELECTOR = "root";
    public static final String COMMENT_OPEN = "<!--";
    public static final String COMMENT_CLOSE = "-->";
    private static final String XML_TEXT_VALUE = "#text";

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation) throws UnmarshalException {
        return this.fromMarshaled(aExternalRepresentation, null);
    }

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
        char theDelimiter = DocumentProperty.toDelimiter(aProperties, PathMap.DELIMITER);
        try {
            CanonicalMapBuilderImpl theCanonicalMap = new CanonicalMapBuilderImpl(theDelimiter);
            DocumentBuilderFactory theFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder theBuilder = theFactory.newDocumentBuilder();
            Document theDocument = theBuilder.parse(new InputSource(aExternalRepresentation));
            theDocument.normalize();
            NodeList theElements = theDocument.getChildNodes();
            this.visitElements((CanonicalMap.CanonicalMapBuilder)theCanonicalMap, theElements, theCanonicalMap.getRootPath(), theDelimiter);
            this.postProcess((CanonicalMap.CanonicalMapBuilder)theCanonicalMap);
            return theCanonicalMap;
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aExternalRepresentation) + ">!", (Throwable)e);
        }
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.toMarshaled(aDataStructure, null);
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        Object theHeader;
        String theRootElement;
        String string = theRootElement = aProperties != null ? aProperties.get(MarshalParameter.ROOT_ELEMENT.getName()) : null;
        if (theRootElement == null || theRootElement.isEmpty()) {
            theRootElement = ROOT_SELECTOR;
        }
        if (aDataStructure.dirs().size() > 1 || aDataStructure.dirs().size() == 0 && aDataStructure.leaves().size() != 1 || aDataStructure.dirs().size() == 1 && aDataStructure.leaves().size() != 0) {
            aDataStructure = aDataStructure.retrieveTo(theRootElement);
        }
        if (aProperties != null && aProperties.containsKey(MarshalParameter.HEADER.getName()) && aProperties.get(MarshalParameter.HEADER.getName()) == null) {
            theHeader = "";
        } else {
            Object object = theHeader = aProperties != null ? aProperties.get(MarshalParameter.HEADER.getName()) : null;
        }
        if (theHeader == null) {
            boolean isStandAnlone;
            String theVersion;
            String theEncoding;
            String string2 = theEncoding = aProperties != null ? aProperties.get(MarshalParameter.ENCODING.getName()) : null;
            if (theEncoding == null || theEncoding.isEmpty()) {
                theEncoding = Encoding.UTF_8.getCode();
            }
            String string3 = theVersion = aProperties != null ? aProperties.get(MarshalParameter.VERSION.getName()) : null;
            if (theVersion == null || theVersion.isEmpty()) {
                theVersion = "1.0";
            }
            boolean bl = aProperties != null ? !BooleanLiterals.isFalse((String)aProperties.get(MarshalParameter.STAND_ALONE.getName())) : (isStandAnlone = true);
            if (theVersion == null || theVersion.isEmpty()) {
                theVersion = "1.0";
            }
            theHeader = "<?xml version=\"" + theVersion + "\" encoding=\"" + theEncoding + "\" standalone=\"" + (isStandAnlone ? "yes" : "no") + "\"?>";
        }
        if (((String)theHeader).length() != 0) {
            theHeader = (String)theHeader + System.lineSeparator();
        }
        String theXml = XmlCanonicalMapFactory.toXml(aDataStructure, DocumentProperty.hasArrayIndex(aProperties));
        String theComment = DocumentProperty.toComment(aProperties);
        if (theComment != null && theComment.length() > 0) {
            String[] theLines;
            for (String eLine : theLines = theComment.split("\\r?\\n")) {
                theHeader = (String)theHeader + "<!-- " + eLine + " -->" + System.lineSeparator();
            }
        }
        return (String)theHeader + theXml;
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.fromUnmarshaled(aDataStructure, null);
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        String theMarshaled = this.toMarshaled(aDataStructure, aProperties);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }

    protected static String toXml(CanonicalMap aCanonicalMap, boolean hasArrayIndexAttribute) {
        return XmlCanonicalMapFactory.toXml(aCanonicalMap, aCanonicalMap.getRootPath(), "", hasArrayIndexAttribute);
    }

    @Override
    protected void postProcess(CanonicalMap.CanonicalMapBuilder aProperties) {
        String theSuffix = aProperties.getDelimiter() + XML_TEXT_VALUE;
        for (String eKey : new ArrayList(aProperties.keySet())) {
            String eValue;
            String eToPath;
            if (!eKey.endsWith(theSuffix) || aProperties.isLeaf(eToPath = eKey.substring(0, eKey.length() - theSuffix.length())) || (eValue = (String)aProperties.remove((Object)eKey)) == null) continue;
            aProperties.put((Object)eToPath, (Object)eValue);
        }
        super.postProcess(aProperties);
    }

    private static String toXml(CanonicalMap aCanonicalMap, String aPath, String aIndent, boolean hasArrayIndexAttribute) {
        StringBuilder theBuffer = new StringBuilder();
        for (String eChild : aCanonicalMap.children(aPath)) {
            String theArray;
            String ePath = aCanonicalMap.toPath(new String[]{aPath, eChild});
            if (aCanonicalMap.isArray(ePath)) {
                theArray = XmlCanonicalMapFactory.toArrayIndex(aCanonicalMap, aPath, eChild, aIndent, hasArrayIndexAttribute);
                theBuffer.append(theArray);
                continue;
            }
            if (aCanonicalMap.isIndexDir(ePath)) {
                theArray = XmlCanonicalMapFactory.toDirIndex(aCanonicalMap, aPath, eChild, aIndent, hasArrayIndexAttribute);
                theBuffer.append(theArray);
                continue;
            }
            if (eChild.startsWith("" + aCanonicalMap.getAnnotator())) continue;
            String theAttributes = XmlCanonicalMapFactory.toAttributes(aCanonicalMap, ePath);
            String eElement = XmlCanonicalMapFactory.toElement(aCanonicalMap, aPath, eChild, aIndent, theAttributes, hasArrayIndexAttribute);
            theBuffer.append(eElement);
        }
        return theBuffer.toString();
    }

    private static String toElement(CanonicalMap aCanonicalMap, String aPath, String aChild, String aIndent, String aAttribs, boolean hasArrayIndexAttribute) {
        String theContent;
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aCanonicalMap.toPath(new String[]{aPath, aChild});
        theBuffer.append(aIndent);
        theBuffer.append("<" + aChild + aAttribs);
        String theValue = "";
        if (aCanonicalMap.containsKey((Object)thePath)) {
            theValue = (String)aCanonicalMap.get((Object)thePath);
        }
        if (((theContent = XmlCanonicalMapFactory.toXml(aCanonicalMap, thePath, aIndent + "\t", hasArrayIndexAttribute)) == null || theContent.isEmpty()) && (theValue == null || theValue.isEmpty())) {
            theBuffer.append("/>");
        } else {
            theBuffer.append(">");
            theBuffer.append(theValue);
            if (theContent.length() != 0) {
                theBuffer.append(System.lineSeparator());
                theBuffer.append(theContent);
                theBuffer.append(aIndent);
            }
            theBuffer.append("</" + aChild + ">");
            theBuffer.append(System.lineSeparator());
        }
        return theBuffer.toString();
    }

    private static String toAttributes(CanonicalMap aCanonicalMap, String aPath) {
        StringBuilder theBuffer = new StringBuilder();
        Set theAttribPaths = aCanonicalMap.queryPaths(new String[]{aPath, PathMap.ANNOTATOR + "*"});
        for (String ePath : theAttribPaths) {
            String eValue = (String)aCanonicalMap.get((Object)ePath);
            String eLeaf = aCanonicalMap.toLeaf(ePath).substring(1);
            if (theBuffer.length() != 0) {
                theBuffer.append(" ");
            }
            theBuffer.append(eLeaf);
            theBuffer.append('=');
            theBuffer.append('\"');
            theBuffer.append(eValue);
            theBuffer.append('\"');
        }
        if (theBuffer.length() != 0) {
            theBuffer.insert(0, ' ');
        }
        return theBuffer.toString();
    }

    private static String toArrayIndex(CanonicalMap aCanonicalMap, String aPath, String aChild, String aIndent, boolean hasArrayIndexAttribute) {
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aCanonicalMap.toPath(new String[]{aPath, aChild});
        int[] indexes = aCanonicalMap.getArrayIndexes(thePath);
        String theAttribs = XmlCanonicalMapFactory.toAttributes(aCanonicalMap, thePath);
        for (int i : indexes) {
            String eIndex = XmlCanonicalMapFactory.toArrayIndex(aCanonicalMap, thePath, i, aChild, theAttribs, aIndent, hasArrayIndexAttribute);
            theBuffer.append(eIndex);
        }
        return theBuffer.toString();
    }

    private static String toArrayIndex(CanonicalMap aCanonicalMap, String aPath, int aIndex, String aElement, String aAttribs, String aIndent, boolean hasArrayIndexAttribute) {
        String theValue;
        String theAttribs = XmlCanonicalMapFactory.toAttributes(aCanonicalMap, aCanonicalMap.toPath(new Object[]{aPath, aIndex}));
        aAttribs = (String)aAttribs + theAttribs;
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(aIndent);
        theBuffer.append("<");
        theBuffer.append(aElement);
        theBuffer.append((String)aAttribs);
        if (hasArrayIndexAttribute) {
            theBuffer.append(" index=\"");
            theBuffer.append(aIndex);
            theBuffer.append("\"");
        }
        if ((theValue = (String)aCanonicalMap.get(new Object[]{aPath, aIndex})) == null || theValue.isEmpty()) {
            theBuffer.append("/>");
        } else {
            theBuffer.append('>');
            theBuffer.append(theValue);
            theBuffer.append("</");
            theBuffer.append(aElement);
            theBuffer.append('>');
        }
        theBuffer.append(System.lineSeparator());
        return theBuffer.toString();
    }

    private static String toDirIndex(CanonicalMap aCanonicalMap, String aPath, String aChild, String aIndent, boolean hasArrayIndexAttribute) {
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aCanonicalMap.toPath(new String[]{aPath, aChild});
        int[] indexes = aCanonicalMap.getDirIndexes(thePath);
        String theAttribs = XmlCanonicalMapFactory.toAttributes(aCanonicalMap, thePath);
        for (int i : indexes) {
            CanonicalMap eCanonicalMap = aCanonicalMap.getDirAt(thePath, i);
            String eIndex = XmlCanonicalMapFactory.toDirIndex(eCanonicalMap, thePath, i, aChild, theAttribs, aIndent, hasArrayIndexAttribute);
            theBuffer.append(eIndex);
        }
        return theBuffer.toString();
    }

    private static String toDirIndex(CanonicalMap aCanonicalMap, String aPath, int aIndex, String aElement, String aAttribs, String aIndent, boolean hasArrayIndexAttribute) {
        String theValue;
        StringBuilder theBuffer = new StringBuilder();
        String theAttribs = XmlCanonicalMapFactory.toAttributes(aCanonicalMap, aCanonicalMap.getRootPath());
        theBuffer.append(aIndent);
        theBuffer.append("<");
        theBuffer.append(aElement);
        theBuffer.append(aAttribs);
        theBuffer.append(theAttribs);
        if (hasArrayIndexAttribute) {
            theBuffer.append(" index=\"");
            theBuffer.append(aIndex);
            theBuffer.append("\"");
        }
        if ((theValue = XmlCanonicalMapFactory.toXml(aCanonicalMap, "", aIndent + "\t", hasArrayIndexAttribute)) == null || theValue.isEmpty()) {
            theBuffer.append("/>");
        } else {
            theBuffer.append('>');
            theBuffer.append(System.lineSeparator());
            theBuffer.append(theValue);
            theBuffer.append(System.lineSeparator());
            theBuffer.append(aIndent);
            theBuffer.append("</");
            theBuffer.append(aElement);
            theBuffer.append('>');
        }
        theBuffer.append(System.lineSeparator());
        return theBuffer.toString();
    }

    private void visitElements(CanonicalMap.CanonicalMapBuilder aCanonicalMap, NodeList aElements, String aPath, char aDelimiter) {
        for (int i = 0; i < aElements.getLength(); ++i) {
            this.visitElement(aCanonicalMap, aElements.item(i), aPath, aDelimiter);
        }
    }

    private void visitElement(CanonicalMap.CanonicalMapBuilder aCanonicalMap, Node aElement, String aPath, char aDelimiter) {
        aPath = aCanonicalMap.toPath(new String[]{aPath, aElement.getNodeName()});
        int next = this.toAttributeIndex(aElement.getAttributes());
        if (next != -1) {
            aPath = aCanonicalMap.toPath(new Object[]{aPath, next});
        }
        aPath = this.toIndexed(aCanonicalMap, aPath);
        NodeList eChildren = aElement.getChildNodes();
        if (aElement.getNodeType() == 3 || aElement.getNodeType() == 4) {
            String eValue = aElement.getTextContent();
            if (eValue != null && eValue.trim().isEmpty()) {
                eValue = null;
            }
            if (eValue != null) {
                aCanonicalMap.add(aPath, (Object)eValue);
            }
        }
        this.visitAttributes(aCanonicalMap, aElement.getAttributes(), aPath);
        this.visitElements(aCanonicalMap, eChildren, aPath, aDelimiter);
    }

    private void visitAttributes(CanonicalMap.CanonicalMapBuilder aCanonicalMap, NamedNodeMap aAttribs, String aPath) {
        if (aAttribs != null) {
            for (int i = 0; i < aAttribs.getLength(); ++i) {
                Node eAttribute = aAttribs.item(i);
                this.visitAttribute(aCanonicalMap, aPath, eAttribute);
            }
        }
    }

    private void visitAttribute(CanonicalMap.CanonicalMapBuilder aCanonicalMap, String aPath, Node eAttribute) {
        if (!"index".equals(eAttribute.getNodeName())) {
            aPath = aCanonicalMap.toPath(new String[]{aPath, PathMap.ANNOTATOR + eAttribute.getNodeName()});
            aCanonicalMap.add(aPath, (Object)eAttribute.getNodeValue());
        }
    }

    private int toAttributeIndex(NamedNodeMap aAttribs) {
        int index = -1;
        if (aAttribs != null) {
            try {
                for (int i = 0; i < aAttribs.getLength(); ++i) {
                    Node eAttribute = aAttribs.item(i);
                    if (!"index".equals(eAttribute.getNodeName())) continue;
                    return Integer.parseInt(eAttribute.getNodeValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private String toIndexed(CanonicalMap.CanonicalMapBuilder aCanonicalMap, String aPath) {
        if (aCanonicalMap.isIndexDir(aPath)) {
            aPath = aCanonicalMap.toPath(new Object[]{aPath, aCanonicalMap.nextDirIndex(aPath)});
        } else if (aCanonicalMap.isDir(aPath)) {
            CanonicalMap theSubDirs = aCanonicalMap.removeFrom(aPath);
            aCanonicalMap.insertTo(aCanonicalMap.toPath(new String[]{aPath, "0"}), theSubDirs);
            aPath = aCanonicalMap.toPath(new String[]{aPath, "1"});
        }
        return aPath;
    }
}

