/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.schema;

import java.util.ArrayList;
import java.util.HashMap;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.ChildrenAccessor;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.schema.JsonVisitor;
import org.refcodes.schema.SchemaVisitor;

public class Schema
extends HashMap<String, Object>
implements ChildrenAccessor<Schema[]>,
TypeAccessor,
AliasAccessor,
DescriptionAccessor {
    private static final long serialVersionUID = 1L;
    public static String ALIAS = "ALIAS";
    public static String COMMENT = "COMMENT";
    public static String DESCRIPTION = "DESCRIPTION";
    public static String EXCEPTION = "EXCEPTION";
    public static String KEY = "KEY";
    public static String TYPE = "TYPE";
    public static String VALUE = "VALUE";
    public static String VERBOSE = "VERBOSE";
    private Schema[] _children = null;

    public Schema(Class<?> aType, String aDescription) {
        this.put(TYPE, aType);
        this.put(DESCRIPTION, aDescription);
    }

    public Schema(String aAlias, Class<?> aType) {
        this.put(TYPE, aType);
        this.put(ALIAS, aAlias);
    }

    public Schema(String aAlias, Class<?> aType, String aDescription) {
        this.put(TYPE, aType);
        this.put(ALIAS, aAlias);
        this.put(DESCRIPTION, aDescription);
    }

    public Schema(Class<?> aType, String aDescription, Schema ... aChildren) {
        this._children = aChildren;
        this.put(TYPE, aType);
        this.put(DESCRIPTION, aDescription);
    }

    public Schema(String aAlias, Class<?> aType, String aDescription, Schema ... aChildren) {
        this._children = aChildren;
        this.put(TYPE, aType);
        this.put(ALIAS, aAlias);
        this.put(DESCRIPTION, aDescription);
    }

    public Schema(Schema aSchema) {
        super(aSchema);
        this._children = aSchema.getChildren();
        this.put(TYPE, aSchema.getType());
        this.put(ALIAS, aSchema.getAlias());
        this.put(DESCRIPTION, aSchema.getDescription());
    }

    public Schema(Class<?> aType, Schema aSchema) {
        this._children = aSchema.getChildren();
        this.putAll(aSchema);
        this.put(TYPE, aType);
        this.put(ALIAS, aSchema.getAlias());
        this.put(DESCRIPTION, aSchema.getDescription());
    }

    public Schema(Schema aSchema, Schema ... aChildren) {
        super(aSchema);
        this._children = aChildren;
        this.put(TYPE, aSchema.getType());
        this.put(ALIAS, aSchema.getAlias());
        this.put(DESCRIPTION, aSchema.getDescription());
    }

    public String getAlias() {
        return (String)this.get(ALIAS);
    }

    public Class<?> getType() {
        return (Class)this.get(TYPE);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public Schema[] getChildren() {
        return this._children;
    }

    public <T> T visit(SchemaVisitor<T> aVisitor) {
        ArrayList<T> theResults = new ArrayList<T>();
        if (this.getChildren() != null) {
            for (Schema eChild : this.getChildren()) {
                theResults.add(eChild.visit(aVisitor));
            }
        }
        if (theResults.isEmpty()) {
            return aVisitor.visit(this, null);
        }
        return aVisitor.visit(this, theResults);
    }

    @Override
    public String toString() {
        return this.visit(new JsonVisitor());
    }
}

