/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.Terminal;

public enum Shell {
    SHELL,
    WIN_CMD,
    POWER_SHELL,
    NONE,
    UNKNOWN;

    private static final String CMD_EXE = "cmd.exe";
    private static final String COM_SPEC = "ComSpec";

    public static Shell toShell() {
        if (Terminal.isCygwinTerminal()) {
            return SHELL;
        }
        boolean bl = System.console() != null;
        switch (OperatingSystem.toOperatingSystem()) {
            case WINDOWS: {
                if (!bl) break;
                String string = System.getenv(COM_SPEC);
                if (string != null && string.endsWith(CMD_EXE)) {
                    return WIN_CMD;
                }
                return POWER_SHELL;
            }
            case UNIX: {
                if (!bl) break;
                return SHELL;
            }
        }
        return bl ? UNKNOWN : NONE;
    }
}

