/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.CharSet;
import org.refcodes.data.Delimiter;
import org.refcodes.mixin.KeyAccessor;

public class PropertyBuilder
implements KeyAccessor.KeyProperty<String>,
KeyAccessor.KeyBuilder<String, PropertyBuilder> {
    private String _key = null;

    public String getKey() {
        return this._key;
    }

    public void setKey(String string) {
        this._key = string;
    }

    public PropertyBuilder withKey(String string) {
        this.setKey(string);
        return this;
    }

    public String toPath() {
        return this.toPath(this.getKey());
    }

    public String toPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = PropertyBuilder.asNormalized(string, Delimiter.PATH.getChar());
        return string2 != null ? Delimiter.PATH.getChar() + string2.toLowerCase() : string2;
    }

    public String toSystemProperty() {
        return this.toSystemProperty(this.getKey());
    }

    public String toEnvironmentVariable() {
        return this.toEnvironmentVariable(this.getKey());
    }

    public String toSystemProperty(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = PropertyBuilder.asNormalized(string, Delimiter.NAMESPACE.getChar());
        return string2 != null ? string2.toLowerCase() : string2;
    }

    public String toEnvironmentVariable(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = PropertyBuilder.asNormalized(string, Delimiter.SNAKE_CASE.getChar());
        return string2 != null ? string2.toUpperCase() : string2;
    }

    public String getSystemProperty(String string) {
        String string2 = this.toSystemProperty(string);
        return System.getProperty(string2 != null ? string2 : string);
    }

    public String getEnvironmentVariable(String string) {
        String string2 = this.toEnvironmentVariable(string);
        return System.getenv(string2 != null ? string2 : string);
    }

    protected static String asNormalized(String string, char c) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = CharSet.REGEX_SPECIAL_CHARS.hasChar(c) ? "\\" + c : "" + c;
        String string3 = string2 + string2;
        String string4 = "" + c + c;
        String string5 = "" + c;
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (string.length() > 0 && !Character.isAlphabetic(string.charAt(0)) && !Character.isDigit(string.charAt(0))) {
            string = string.substring(1);
        }
        while (string.length() > 0 && !Character.isAlphabetic(string.charAt(string.length() - 1)) && !Character.isDigit(string.charAt(string.length() - 1))) {
            string = string.substring(0, string.length() - 1);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        stringBuffer.append(string.charAt(0));
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isLowerCase(string.charAt(i - 1)) && Character.isUpperCase(string.charAt(i))) {
                stringBuffer.append(c);
            }
            if (!Character.isAlphabetic(string.charAt(i)) && !Character.isDigit(string.charAt(i))) {
                stringBuffer.append(c);
                continue;
            }
            if (Character.isDigit(string.charAt(i)) && stringBuffer.length() != 0 && Character.isAlphabetic(stringBuffer.charAt(stringBuffer.length() - 1))) {
                stringBuffer.append(c);
            } else if (Character.isAlphabetic(string.charAt(i)) && stringBuffer.length() != 0 && Character.isDigit(stringBuffer.charAt(stringBuffer.length() - 1))) {
                stringBuffer.append(c);
            }
            stringBuffer.append(string.charAt(i));
        }
        String string6 = stringBuffer.toString();
        while (string6.indexOf(string4) != -1) {
            string6 = string6.replaceAll(string3, string5);
        }
        return string6.toLowerCase();
    }
}

