/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusException;

public class RestEndpointBuilder
implements RestEndpoint,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestEndpointBuilder>,
LinkComponent.LinkComponentBuilder<RestEndpointBuilder>,
ConnectionStatusAccessor {
    private static Logger LOGGER = Logger.getLogger(RestEndpointBuilder.class.getName());
    protected RestRequestConsumer _requestObserver = null;
    protected HttpMethod _httpMethod = HttpMethod.GET;
    protected String _locatorPathPattern = null;
    protected Pattern _locatorRegExp = null;
    protected ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestEndpointBuilder() {
    }

    public RestEndpointBuilder(HttpMethod httpMethod, String string, RestRequestConsumer restRequestConsumer) {
        this._httpMethod = httpMethod;
        this._locatorPathPattern = string;
        this._requestObserver = restRequestConsumer;
    }

    public RestEndpointBuilder(HttpMethod httpMethod, Pattern pattern, RestRequestConsumer restRequestConsumer) {
        this._httpMethod = httpMethod;
        this._locatorRegExp = pattern;
        this._requestObserver = restRequestConsumer;
    }

    public RestEndpointBuilder withHttpMethod(HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public RestEndpointBuilder withLocatorPathPattern(String string) {
        this.setLocatorPathPattern(string);
        return this;
    }

    public RestEndpointBuilder withLocatorRegExp(Pattern pattern) {
        this.setLocatorRegExp(pattern);
        return this;
    }

    public RestEndpointBuilder withRequestObserver(RestRequestConsumer restRequestConsumer) {
        this.setRequestObserver(restRequestConsumer);
        return this;
    }

    public RestEndpointBuilder withOpen() throws IOException {
        this.open();
        return this;
    }

    public RestEndpointBuilder withClose() throws IOException {
        this.close();
        return this;
    }

    public RestEndpointBuilder withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    public RestEndpointBuilder withCloseIn(int n) {
        this.closeIn(n);
        return this;
    }

    public void setLocatorPathPattern(String string) {
        this._locatorPathPattern = string;
        this._locatorRegExp = null;
    }

    public void setLocatorRegExp(Pattern pattern) {
        this._locatorRegExp = pattern;
        this._locatorPathPattern = null;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this._httpMethod = httpMethod;
    }

    public void setRequestObserver(RestRequestConsumer restRequestConsumer) {
        this._requestObserver = restRequestConsumer;
    }

    public RestRequestConsumer getRequestObserver() {
        return this._requestObserver;
    }

    @Override
    public void onRequest(RestRequestEvent restRequestEvent, HttpServerResponse httpServerResponse) throws HttpStatusException {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            this._requestObserver.onRequest(restRequestEvent, httpServerResponse);
        } else {
            LOGGER.log(Level.WARNING, "Ignoring request <" + restRequestEvent + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may not have opened it?");
        }
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public String getLocatorPathPattern() {
        return this._locatorPathPattern;
    }

    @Override
    public Pattern getLocatorRegExp() {
        return this._locatorRegExp;
    }

    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }
}

