/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;

public class ReplayInputStream
extends InputStream {
    private final InputStream _inputStream;
    private int[] _buffer = null;
    private int _readIndex = -1;
    private int _writeIndex = -1;

    public ReplayInputStream(InputStream aInputStream) {
        this._inputStream = aInputStream;
    }

    @Override
    public int read() throws IOException {
        if (this._readIndex >= 0 && this._readIndex < this._buffer.length && this._writeIndex > this._readIndex) {
            return this._buffer[this._readIndex++];
        }
        byte[] theValue = new byte[1];
        if (this._inputStream.read(theValue) <= 0) {
            return -1;
        }
        if (this._writeIndex >= 0) {
            if (this._writeIndex < this._buffer.length) {
                this._buffer[this._writeIndex] = theValue[0];
            }
            ++this._writeIndex;
            ++this._readIndex;
        }
        return Byte.toUnsignedInt(theValue[0]);
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this._buffer == null || this._buffer.length != readlimit) {
            this._buffer = new int[readlimit];
        }
        this._readIndex = 0;
        this._writeIndex = 0;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this._writeIndex == -1 || this._writeIndex > this._buffer.length) {
            throw new IOException("Resetting to invalid mark from index <" + this._writeIndex + "> outside the scope of the read limit <" + (this._buffer != null ? this._buffer.length : 0) + ">");
        }
        this._readIndex = 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

