/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.refcodes.data.FilenameExtension;

public class ZipUtility {
    public static InputStream toInputStream(File aFile) throws ZipException, IOException, FileNotFoundException {
        String theUnZipFileName = ZipUtility.toFileNameFromZip(aFile.getName());
        if (theUnZipFileName != null) {
            ZipFile theZipFile = new ZipFile(aFile);
            if (theZipFile.size() != 1) {
                throw new ZipException("The file \"" + aFile.getAbsolutePath() + "\" has <" + theZipFile.size() + "\" entries, expecting exactly one entry with name \"" + theUnZipFileName + "\"!");
            }
            Enumeration<? extends ZipEntry> e = theZipFile.entries();
            ZipEntry theEntry = e.nextElement();
            if (!theUnZipFileName.equals(theEntry.getName())) {
                throw new ZipException("The file \"" + aFile.getAbsolutePath() + "\" contains an entry with name \"" + theEntry.getName() + "\", though expecting entry with name \"" + theUnZipFileName + "\"!");
            }
            return new BufferedInputStream(theZipFile.getInputStream(theEntry));
        }
        return new BufferedInputStream(new FileInputStream(aFile));
    }

    public static String toFileNameFromZip(String aZipFileName) {
        if (aZipFileName.toLowerCase().endsWith(FilenameExtension.ZIP.getFilenameSuffix())) {
            return aZipFileName.substring(0, aZipFileName.length() - FilenameExtension.ZIP.getFilenameSuffix().length());
        }
        return null;
    }
}

