/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.data.IoTimeout;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.mixin.ReadTimeoutInMsAccessor;

public class TimeoutInputStream
extends InputStream
implements ReadTimeoutInMsAccessor {
    private InputStream _inputStream;
    private long _readTimeoutInMs;
    private Object _monitor;
    private boolean _isClosed;

    public TimeoutInputStream(InputStream aInputStream, long aTimeoutInMs) {
        this(aInputStream, aTimeoutInMs, null);
    }

    public TimeoutInputStream(InputStream aInputStream, Object aMonitor) {
        this(aInputStream, -1L, aMonitor);
    }

    public TimeoutInputStream(InputStream aInputStream) {
        this(aInputStream, -1L, null);
    }

    public TimeoutInputStream(InputStream aInputStream, long aTimeoutInMs, Object aMonitor) {
        this._inputStream = aInputStream;
        this._readTimeoutInMs = aTimeoutInMs;
        this._monitor = aMonitor != null ? aMonitor : this;
    }

    @Override
    public int read() throws IOException {
        return this.read(this._readTimeoutInMs);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len, this._readTimeoutInMs);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, this._readTimeoutInMs);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.readNBytes(b, off, len, this._readTimeoutInMs);
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.readNBytes(len, this._readTimeoutInMs);
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this._isClosed = true;
        this._inputStream.close();
        super.close();
    }

    @Override
    public void mark(int readlimit) {
        this._inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this._inputStream.skip(n);
    }

    public int read(long aTimeoutInMs) throws IOException {
        if (this._isClosed) {
            return -1;
        }
        try {
            this.waitForBytesAvailable(1, aTimeoutInMs);
            return this._inputStream.read();
        }
        catch (EOFException e) {
            return -1;
        }
        catch (IOException e) {
            if (this._isClosed) {
                return -1;
            }
            throw e;
        }
    }

    public int read(byte[] b, int off, int len, long aTimeoutInMs) throws IOException {
        try {
            this.waitForBytesAvailable(len, aTimeoutInMs);
            return this._inputStream.read(b, off, len);
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public int read(byte[] b, long aTimeoutInMs) throws IOException {
        if (b != null && b.length != 0) {
            int len = b.length;
            try {
                this.waitForBytesAvailable(len, aTimeoutInMs);
                return this._inputStream.read(b);
            }
            catch (EOFException e) {
                return -1;
            }
        }
        return 0;
    }

    public int readNBytes(byte[] b, int off, int len, long aTimeoutInMs) throws IOException {
        if (b != null && b.length != 0) {
            try {
                this.waitForBytesAvailable(len, aTimeoutInMs);
                return this._inputStream.readNBytes(b, off, len);
            }
            catch (EOFException e) {
                return -1;
            }
        }
        return 0;
    }

    public byte[] readNBytes(int len, long aTimeoutInMs) throws IOException {
        if (len > 0) {
            this.waitForBytesAvailable(len, aTimeoutInMs);
            return this._inputStream.readNBytes(len);
        }
        return new byte[0];
    }

    public long getReadTimeoutInMs() {
        return this._readTimeoutInMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBytesAvailable(int aNumberOfBytes, long aTimeoutInMs) throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        if (super.available() == 0 && this._inputStream.markSupported()) {
            this._inputStream.mark(1);
            int theValue = 0;
            try {
                theValue = this._inputStream.read();
                if (theValue != -1) {
                    return;
                }
            }
            catch (Exception exception) {
            }
            finally {
                this._inputStream.reset();
            }
            if (theValue == -1) {
                throw new EOFException("Reached end of file (stream), no more data avaialble!");
            }
        }
        if (aTimeoutInMs != -1L) {
            long theStartTimeMs = System.currentTimeMillis();
            while (!this._isClosed && this.available() < aNumberOfBytes && System.currentTimeMillis() - theStartTimeMs < aTimeoutInMs) {
                Object object = this._monitor;
                synchronized (object) {
                    try {
                        this._monitor.wait(IoTimeout.toTimeoutSleepLoopTimeInMs((long)aTimeoutInMs));
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while trying to read <" + aNumberOfBytes + "> number of bytes after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutInMs + "> milliseconds) as of: " + e.getMessage(), e);
                    }
                }
            }
            if (this._isClosed) {
                throw new IOException("Connection was closed after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutInMs + "> milliseconds) while trying to read <" + aNumberOfBytes + "> number of bytes.");
            }
            if (this.available() < aNumberOfBytes) {
                throw new TimeoutIOException(aTimeoutInMs, "Operation timed out after <" + aTimeoutInMs + "> milliseconds while trying to read <" + aNumberOfBytes + "> number of bytes.");
            }
        }
    }

    public static class DummyTimeoutInputStream
    extends TimeoutInputStream {
        private InputStream _inputStream;

        public DummyTimeoutInputStream(InputStream aInputStream) {
            super(aInputStream);
            this._inputStream = aInputStream;
        }

        @Override
        public int available() throws IOException {
            return this._inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this._inputStream.close();
        }

        public boolean equals(Object aObj) {
            return this._inputStream.equals(aObj);
        }

        public int hashCode() {
            return this._inputStream.hashCode();
        }

        @Override
        public void mark(int aReadlimit) {
            this._inputStream.mark(aReadlimit);
        }

        @Override
        public boolean markSupported() {
            return this._inputStream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this._inputStream.read();
        }

        @Override
        public int read(byte[] aB, int aOff, int aLen) throws IOException {
            return this._inputStream.read(aB, aOff, aLen);
        }

        @Override
        public int read(byte[] aB) throws IOException {
            return this._inputStream.read(aB);
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            return this._inputStream.readAllBytes();
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this._inputStream.readNBytes(b, off, len);
        }

        @Override
        public byte[] readNBytes(int aArg0) throws IOException {
            return this._inputStream.readNBytes(aArg0);
        }

        @Override
        public void reset() throws IOException {
            this._inputStream.reset();
        }

        @Override
        public long skip(long aArg0) throws IOException {
            return this._inputStream.skip(aArg0);
        }

        public String toString() {
            return this._inputStream.toString();
        }

        @Override
        public long transferTo(OutputStream aOut) throws IOException {
            return this._inputStream.transferTo(aOut);
        }
    }
}

