/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.io.Skippable;
import org.refcodes.mixin.ReadTimeoutInMsAccessor;

public class SkipAvailableInputStream
extends InputStream
implements ReadTimeoutInMsAccessor,
Skippable {
    private InputStream _inputStream;
    private long _readTimeoutInMs;

    public SkipAvailableInputStream(InputStream aInputStream) {
        this(aInputStream, -1L);
    }

    public SkipAvailableInputStream(InputStream aInputStream, long aTimeoutInMs) {
        this._inputStream = aInputStream;
        this._readTimeoutInMs = aTimeoutInMs;
    }

    @Override
    public void skipAvailableTillSilenceFor(long aSilenceTimeSpanInMs) throws IOException, TimeoutIOException {
        this.skipAvailableTillSilenceFor(aSilenceTimeSpanInMs, this.getReadTimeoutInMs());
    }

    @Override
    public void skipAvailableWithin(long aSkipTimeSpanInMs) throws IOException {
        this.skipAvailableWithin(aSkipTimeSpanInMs, this.getReadTimeoutInMs());
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public int read() throws IOException {
        return this._inputStream.read();
    }

    @Override
    public int read(byte[] aB, int aOff, int aLen) throws IOException {
        return this._inputStream.read(aB, aOff, aLen);
    }

    @Override
    public int read(byte[] aB) throws IOException {
        return this._inputStream.read(aB);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this._inputStream.readAllBytes();
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this._inputStream.readNBytes(b, off, len);
    }

    @Override
    public byte[] readNBytes(int aArg0) throws IOException {
        return this._inputStream.readNBytes(aArg0);
    }

    public String toString() {
        return this._inputStream.toString();
    }

    @Override
    public long transferTo(OutputStream aOut) throws IOException {
        return this._inputStream.transferTo(aOut);
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
        super.close();
    }

    @Override
    public void mark(int readlimit) {
        this._inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this._inputStream.skip(n);
    }

    public long getReadTimeoutInMs() {
        return this._readTimeoutInMs;
    }
}

