/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.DatagramReceiver;
import org.refcodes.io.DatagramsDestination;

public interface DatagramsReceiver<DATA extends Serializable>
extends DatagramReceiver<DATA>,
DatagramsDestination<DATA> {
    @Override
    default public DATA[] receiveAll() throws IOException, EOFException {
        ArrayList theData = new ArrayList();
        while (this.hasAvailable()) {
            theData.add(this.receive());
        }
        return theData.toArray((Serializable[])new Object[theData.size()]);
    }

    @Override
    default public DATA[] receive(int aMaxSize) throws IOException, EOFException {
        int i;
        Serializable[] theBlock = (Serializable[])new Object[aMaxSize];
        for (i = 0; this.hasAvailable() && i < aMaxSize; ++i) {
            theBlock[i] = this.receive();
        }
        if (i == 0) {
            while (!this.hasAvailable()) {
                try {
                    Thread.sleep(SleepLoopTime.NORM.getTimeInMs());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (this.hasAvailable() && i < aMaxSize) {
                    theBlock[i] = this.receive();
                    ++i;
                }
            }
        }
        if (i == aMaxSize) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }
}

