/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import org.refcodes.component.Closable;
import org.refcodes.component.Flushable;
import org.refcodes.io.AbstractBytesTransmitter;
import org.refcodes.io.BytesSource;
import org.refcodes.io.BytesTransmitter;

public class ByteTransmitterDecorator
extends AbstractBytesTransmitter
implements BytesTransmitter {
    private BytesSource _byteConsumer;

    public ByteTransmitterDecorator(BytesSource aByteConsumer) {
        this._byteConsumer = aByteConsumer;
        try {
            this.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void transmitByte(byte aByte) throws IOException {
        this._byteConsumer.transmitByte(aByte);
    }

    @Override
    public void transmitAllBytes(byte[] aBytes) throws IOException {
        this._byteConsumer.transmitAllBytes(aBytes);
    }

    @Override
    public void transmitBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        this._byteConsumer.transmitBytes(aBytes, aOffset, aLength);
    }

    @Override
    public void flush() throws IOException {
        if (this._byteConsumer instanceof Flushable) {
            ((Flushable)this._byteConsumer).flush();
        }
    }

    public void close() throws IOException {
        if (this._byteConsumer instanceof Closable) {
            ((Closable)this._byteConsumer).close();
        }
        super.close();
    }
}

