/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Color;
import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.RgbColor;

public class RgbColorImpl
implements RgbColor {
    private int _alphaPortion = 0;
    private int _redPortion = 0;
    private int _greenPortion = 0;
    private int _bluePortion = 0;

    public RgbColorImpl() {
    }

    public RgbColorImpl(int n, int n2, int n3, int n4) {
        this._alphaPortion = n;
        this._redPortion = n2;
        this._greenPortion = n3;
        this._bluePortion = n4;
    }

    public RgbColorImpl(int n) {
        this.setRgbValue(n);
    }

    public RgbColorImpl(Color color) {
        this(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public int getAlpha() {
        return this._alphaPortion;
    }

    @Override
    public int getRed() {
        return this._redPortion;
    }

    @Override
    public int getGreen() {
        return this._greenPortion;
    }

    @Override
    public int getBlue() {
        return this._bluePortion;
    }

    @Override
    public int toRgbValue() {
        return GraphicalUtility.toRgb(this._alphaPortion, this._redPortion, this._greenPortion, this._bluePortion);
    }

    @Override
    public void setRgbValue(int n) {
        this._alphaPortion = GraphicalUtility.toAlpha(n);
        this._redPortion = GraphicalUtility.toRed(n);
        this._greenPortion = GraphicalUtility.toGreen(n);
        this._bluePortion = GraphicalUtility.toBlue(n);
    }

    @Override
    public void setAlphaPortion(int n) {
        this._alphaPortion = n;
    }

    @Override
    public void setRedPortion(int n) {
        this._redPortion = n;
    }

    @Override
    public void setGreenPortion(int n) {
        this._greenPortion = n;
    }

    @Override
    public void setBluePortion(int n) {
        this._bluePortion = n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._alphaPortion;
        n = 31 * n + this._bluePortion;
        n = 31 * n + this._greenPortion;
        n = 31 * n + this._redPortion;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RgbColorImpl rgbColorImpl = (RgbColorImpl)object;
        if (this._alphaPortion != rgbColorImpl._alphaPortion) {
            return false;
        }
        if (this._bluePortion != rgbColorImpl._bluePortion) {
            return false;
        }
        if (this._greenPortion != rgbColorImpl._greenPortion) {
            return false;
        }
        return this._redPortion == rgbColorImpl._redPortion;
    }
}

