/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.PublishSubscribeService;
import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.SubscriptionListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

public class RedissonSubscription
extends AbstractSubscription {
    private static final CompletableFuture<Void> COMPLETED = new CompletableFuture();
    private final Map<ChannelName, CompletableFuture<Void>> subscribed = new ConcurrentHashMap<ChannelName, CompletableFuture<Void>>();
    private final Map<ChannelName, CompletableFuture<Void>> psubscribed = new ConcurrentHashMap<ChannelName, CompletableFuture<Void>>();
    private final CommandAsyncExecutor commandExecutor;
    private final PublishSubscribeService subscribeService;

    public RedissonSubscription(CommandAsyncExecutor commandExecutor, MessageListener listener) {
        super(listener, null, null);
        this.commandExecutor = commandExecutor;
        this.subscribeService = commandExecutor.getConnectionManager().getSubscribeService();
    }

    protected void doSubscribe(byte[] ... channels) {
        Map<ChannelName, CompletableFuture<Void>> tosubscribe = this.getNonSubscribed(channels, this.subscribed, (l, ch) -> ((SubscriptionListener)this.getListener()).onChannelSubscribed(ch, 1L));
        if (tosubscribe.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        final CountDownLatch latch = new CountDownLatch(1);
        for (final ChannelName channel : tosubscribe.keySet()) {
            CompletableFuture f = this.subscribeService.subscribe((Codec)ByteArrayCodec.INSTANCE, channel, new RedisPubSubListener[]{new BaseRedisPubSubListener(){

                public void onMessage(CharSequence ch, Object message) {
                    if (!Arrays.equals(((ChannelName)ch).getName(), channel.getName())) {
                        return;
                    }
                    byte[] m = RedissonSubscription.this.toBytes(message);
                    DefaultMessage msg = new DefaultMessage(((ChannelName)ch).getName(), m);
                    RedissonSubscription.this.getListener().onMessage((Message)msg, null);
                }

                public void onStatus(PubSubType type, CharSequence ch) {
                    if (!Arrays.equals(((ChannelName)ch).getName(), channel.getName())) {
                        return;
                    }
                    if (RedissonSubscription.this.getListener() instanceof SubscriptionListener && type == PubSubType.SUBSCRIBE) {
                        CompletableFuture callback = RedissonSubscription.this.subscribed.getOrDefault(channel, COMPLETED);
                        callback.complete(null);
                    }
                    super.onStatus(type, ch);
                    if (type == PubSubType.UNSUBSCRIBE) {
                        RedissonSubscription.this.subscribed.remove(channel);
                        latch.countDown();
                    }
                }
            }});
            list.add(f);
        }
        for (CompletableFuture future : list) {
            this.commandExecutor.get(future);
        }
        if (this.getListener() instanceof SubscriptionListener) {
            for (final ChannelName channel : tosubscribe.keySet()) {
                ((SubscriptionListener)this.getListener()).onChannelSubscribed(channel.getName(), 1L);
            }
        }
        if (this.getListener().getClass().getName().equals("org.springframework.data.redis.listener.SynchronizingMessageListener")) {
            StringWriter sw = new StringWriter();
            new Exception().printStackTrace(new PrintWriter(sw));
            String[] r = sw.toString().split("\n");
            if (r.length != 7) {
                return;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Map<ChannelName, CompletableFuture<Void>> getNonSubscribed(byte[][] channels, Map<ChannelName, CompletableFuture<Void>> subscribed, BiConsumer<SubscriptionListener, byte[]> consumer) {
        HashMap<ChannelName, CompletableFuture<Void>> tosubscribe = new HashMap<ChannelName, CompletableFuture<Void>>();
        for (byte[] ch : channels) {
            ChannelName n = new ChannelName(ch);
            CompletableFuture f = new CompletableFuture();
            CompletableFuture cf = subscribed.putIfAbsent(n, f);
            if (cf == null) {
                tosubscribe.put(n, f);
                continue;
            }
            if (!(this.getListener() instanceof SubscriptionListener)) continue;
            if (cf.isDone()) {
                this.commandExecutor.getServiceManager().getExecutor().submit(() -> consumer.accept((SubscriptionListener)this.getListener(), ch));
                continue;
            }
            cf.thenAccept(r -> consumer.accept((SubscriptionListener)this.getListener(), ch));
        }
        return tosubscribe;
    }

    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        for (byte[] channel : channels) {
            CompletableFuture f = this.subscribeService.unsubscribe(new ChannelName(channel), PubSubType.UNSUBSCRIBE);
            if (!(this.getListener() instanceof SubscriptionListener)) continue;
            f.whenComplete((r, e) -> {
                if (r != null) {
                    ((SubscriptionListener)this.getListener()).onChannelUnsubscribed(channel, 1L);
                }
            });
        }
    }

    protected void doPsubscribe(byte[] ... patterns) {
        Map<ChannelName, CompletableFuture<Void>> tosubscribe = this.getNonSubscribed(patterns, this.psubscribed, (l, ch) -> ((SubscriptionListener)this.getListener()).onPatternSubscribed(ch, 1L));
        if (tosubscribe.isEmpty()) {
            return;
        }
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        final CountDownLatch latch = new CountDownLatch(1);
        for (final ChannelName channel : tosubscribe.keySet()) {
            CompletableFuture f = this.subscribeService.psubscribe(channel, (Codec)ByteArrayCodec.INSTANCE, new RedisPubSubListener[]{new BaseRedisPubSubListener(){

                public void onPatternMessage(CharSequence pattern, CharSequence ch, Object message) {
                    if (!Arrays.equals(((ChannelName)pattern).getName(), channel.getName())) {
                        return;
                    }
                    byte[] m = RedissonSubscription.this.toBytes(message);
                    DefaultMessage msg = new DefaultMessage(((ChannelName)ch).getName(), m);
                    RedissonSubscription.this.getListener().onMessage((Message)msg, ((ChannelName)pattern).getName());
                }

                public void onStatus(PubSubType type, CharSequence pattern) {
                    if (!Arrays.equals(((ChannelName)pattern).getName(), channel.getName())) {
                        return;
                    }
                    if (RedissonSubscription.this.getListener() instanceof SubscriptionListener && type == PubSubType.PSUBSCRIBE) {
                        CompletableFuture callback = RedissonSubscription.this.psubscribed.getOrDefault(channel, COMPLETED);
                        callback.complete(null);
                    }
                    super.onStatus(type, pattern);
                    if (type == PubSubType.PUNSUBSCRIBE) {
                        RedissonSubscription.this.psubscribed.remove(channel);
                        latch.countDown();
                    }
                }
            }});
            list.add(f);
        }
        for (CompletableFuture future : list) {
            this.commandExecutor.get(future);
        }
        if (this.getListener() instanceof SubscriptionListener) {
            for (final ChannelName channel : tosubscribe.keySet()) {
                ((SubscriptionListener)this.getListener()).onPatternSubscribed(channel.getName(), 1L);
            }
        }
        if (this.getListener().getClass().getName().equals("org.springframework.data.redis.listener.SynchronizingMessageListener")) {
            StringWriter sw = new StringWriter();
            new Exception().printStackTrace(new PrintWriter(sw));
            String[] r = sw.toString().split("\n");
            if (r.length != 7) {
                return;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private byte[] toBytes(Object message) {
        if (message instanceof String) {
            return ((String)message).getBytes();
        }
        return (byte[])message;
    }

    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        for (byte[] pattern : patterns) {
            CompletableFuture f = this.subscribeService.unsubscribe(new ChannelName(pattern), PubSubType.PUNSUBSCRIBE);
            if (!(this.getListener() instanceof SubscriptionListener)) continue;
            f.whenComplete((r, e) -> {
                if (r != null) {
                    ((SubscriptionListener)this.getListener()).onPatternUnsubscribed(pattern, 1L);
                }
            });
        }
    }

    protected void doClose() {
        this.doUnsubscribe(false, (byte[][])this.getChannels().toArray((T[])new byte[this.getChannels().size()][]));
        this.doPUnsubscribe(false, (byte[][])this.getPatterns().toArray((T[])new byte[this.getPatterns().size()][]));
    }
}

