/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.DoubleNullSafeReplayConvertor;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.client.protocol.decoder.ScoredSortedSetScanDecoder;
import org.redisson.client.protocol.decoder.ScoredSortedSetScanReplayDecoder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.SetReactiveIterator;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.redisson.spring.data.connection.ScoredSortedSetReplayDecoder;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveZSetCommands
extends RedissonBaseReactive
implements ReactiveZSetCommands {
    private static final RedisCommand<Double> ZADD_FLOAT = new RedisCommand("ZADD", (Convertor)new DoubleNullSafeReplayConvertor());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZRANGE_ENTRY = new RedisCommand("ZRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZRANGE = new RedisCommand("ZRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZREVRANGE_ENTRY = new RedisCommand("ZREVRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZREVRANGE = new RedisCommand("ZREVRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZRANGEBYSCORE = new RedisCommand("ZRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZREVRANGEBYSCORE = new RedisCommand("ZREVRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<ListScanResult<RedisZSetCommands.Tuple>> ZSCAN = new RedisCommand("ZSCAN", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ScoredSortedSetScanDecoder(), new ScoredSortedSetScanReplayDecoder()}));
    private static final RedisStrictCommand<Long> ZCOUNT = new RedisStrictCommand("ZCOUNT");
    private static final RedisStrictCommand<Long> ZREMRANGEBYRANK = new RedisStrictCommand("ZREMRANGEBYRANK");
    private static final RedisStrictCommand<Long> ZREMRANGEBYSCORE = new RedisStrictCommand("ZREMRANGEBYSCORE");
    private static final RedisStrictCommand<Long> ZUNIONSTORE = new RedisStrictCommand("ZUNIONSTORE");
    private static final RedisStrictCommand<Long> ZINTERSTORE = new RedisStrictCommand("ZINTERSTORE");
    private static final RedisCommand<Set<Object>> ZRANGEBYLEX = new RedisCommand("ZRANGEBYLEX", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZREVRANGEBYLEX = new RedisCommand("ZREVRANGEBYLEX", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisStrictCommand<Long> ZREMRANGEBYLEX = new RedisStrictCommand("ZREMRANGEBYLEX");
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZPOPMIN = new RedisCommand("ZPOPMIN", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZPOPMAX = new RedisCommand("ZPOPMAX", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> BZPOPMIN = new RedisCommand("BZPOPMIN", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> BZPOPMAX = new RedisCommand("BZPOPMAX", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZRANDMEMBER_SCORE = new RedisCommand("ZRANDMEMBER", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZDIFF_SCORE = new RedisCommand("ZDIFF", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisStrictCommand<Long> ZDIFFSTORE = new RedisStrictCommand("ZDIFFSTORE");
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZUNION_SCORE = new RedisCommand("ZUNION", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<RedisZSetCommands.Tuple>> ZINTER_SCORE = new RedisCommand("ZINTER", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<List<Object>> ZMSCORE = new RedisCommand("ZMSCORE", (MultiDecoder)new ObjectListReplayDecoder());

    RedissonReactiveZSetCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Number>> zAdd(Publisher<ReactiveZSetCommands.ZAddCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notEmpty((Collection)command.getTuples(), (String)"Tuples must not be empty or null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            ArrayList<Object> params = new ArrayList<Object>(command.getTuples().size() * 2 + 1);
            params.add(keyBuf);
            if (command.isIncr() || command.isUpsert() || command.isReturnTotalChanged()) {
                if (command.isUpsert()) {
                    params.add("NX");
                } else {
                    params.add("XX");
                }
                if (command.isReturnTotalChanged()) {
                    params.add("CH");
                }
                if (command.isIncr()) {
                    params.add("INCR");
                }
            }
            for (RedisZSetCommands.Tuple entry : command.getTuples()) {
                params.add(BigDecimal.valueOf(entry.getScore()).toPlainString());
                params.add(entry.getValue());
            }
            Mono m = command.isIncr() ? this.write(keyBuf, (Codec)DoubleCodec.INSTANCE, ZADD_FLOAT, params.toArray()) : this.write(keyBuf, (Codec)StringCodec.INSTANCE, RedisCommands.ZADD, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>> zRem(Publisher<ReactiveZSetCommands.ZRemCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValues(), (String)"Values must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getValues().size() + 1);
            args.add(RedissonReactiveZSetCommands.toByteArray(command.getKey()));
            args.addAll(command.getValues().stream().map(v -> RedissonReactiveZSetCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono m = this.write((byte[])args.get(0), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZREM_LONG, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>> zIncrBy(Publisher<ReactiveZSetCommands.ZIncrByCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Member must not be null!");
            Assert.notNull((Object)command.getIncrement(), (String)"Increment value must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveZSetCommands.toByteArray(command.getValue());
            Mono m = this.write(keyBuf, (Codec)DoubleCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZINCRBY, keyBuf, new BigDecimal(command.getIncrement().doubleValue()).toPlainString(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>> zRank(Publisher<ReactiveZSetCommands.ZRankCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Member must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveZSetCommands.toByteArray(command.getValue());
            RedisStrictCommand cmd = RedisCommands.ZRANK;
            if (command.getDirection() == Sort.Direction.DESC) {
                cmd = RedisCommands.ZREVRANK;
            }
            Mono m = this.read(keyBuf, (Codec)DoubleCodec.INSTANCE, (RedisCommand<?>)cmd, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<RedisZSetCommands.Tuple>>> zRange(Publisher<ReactiveZSetCommands.ZRangeCommand> commands) {
        return this.execute(commands, command -> {
            Flux flux;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            long start = command.getRange().getLowerBound().getValue().orElse(0L);
            long end = (Long)command.getRange().getUpperBound().getValue().get();
            if (command.getDirection() == Sort.Direction.ASC) {
                if (command.isWithScores()) {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGE_ENTRY, keyBuf, start, end, "WITHSCORES");
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
                } else {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGE, keyBuf, start, end);
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
                }
            } else if (command.isWithScores()) {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE_ENTRY, keyBuf, start, end, "WITHSCORES");
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            } else {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE, keyBuf, start, end);
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
            }
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<RedisZSetCommands.Tuple>>> zRangeByScore(Publisher<ReactiveZSetCommands.ZRangeByScoreCommand> commands) {
        return this.execute(commands, command -> {
            Flux flux;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            String start = this.toLowerBound(command.getRange());
            String end = this.toUpperBound(command.getRange());
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(keyBuf);
            if (command.getDirection() == Sort.Direction.ASC) {
                args.add(start);
            } else {
                args.add(end);
            }
            if (command.getDirection() == Sort.Direction.ASC) {
                args.add(end);
            } else {
                args.add(start);
            }
            if (command.isWithScores()) {
                args.add("WITHSCORES");
            }
            if (command.getLimit().isPresent() && !((RedisZSetCommands.Limit)command.getLimit().get()).isUnlimited()) {
                args.add("LIMIT");
                args.add(((RedisZSetCommands.Limit)command.getLimit().get()).getOffset());
                args.add(((RedisZSetCommands.Limit)command.getLimit().get()).getCount());
            }
            if (command.getDirection() == Sort.Direction.ASC) {
                if (command.isWithScores()) {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYSCORE, args.toArray());
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
                } else {
                    Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZRANGEBYSCORE, args.toArray());
                    flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
                }
            } else if (command.isWithScores()) {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYSCORE, args.toArray());
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            } else {
                Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZREVRANGEBYSCORE, args.toArray());
                flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(b -> new DefaultTuple(b, Double.valueOf(Double.NaN))));
            }
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<RedisZSetCommands.Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getOptions(), (String)"ScanOptions must not be null!");
            final byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Flux flux = Flux.create((Consumer)new SetReactiveIterator<RedisZSetCommands.Tuple>(){

                protected RFuture<ScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                    if (command.getOptions().getPattern() == null) {
                        return RedissonReactiveZSetCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZSCAN, new Object[]{keyBuf, nextIterPos, "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                    }
                    return RedissonReactiveZSetCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZSCAN, new Object[]{keyBuf, nextIterPos, "MATCH", command.getOptions().getPattern(), "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L)});
                }
            });
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    String toLowerBound(Range range) {
        StringBuilder s = new StringBuilder();
        if (!range.getLowerBound().isInclusive()) {
            s.append("(");
        }
        if (!range.getLowerBound().getValue().isPresent() || range.getLowerBound().getValue().get().toString().isEmpty()) {
            s.append("-inf");
        } else {
            s.append(range.getLowerBound().getValue().get());
        }
        return s.toString();
    }

    String toUpperBound(Range range) {
        StringBuilder s = new StringBuilder();
        if (!range.getUpperBound().isInclusive()) {
            s.append("(");
        }
        if (!range.getUpperBound().getValue().isPresent() || range.getUpperBound().getValue().get().toString().isEmpty()) {
            s.append("+inf");
        } else {
            s.append(range.getUpperBound().getValue().get());
        }
        return s.toString();
    }

    String toLexLowerBound(Range range, Object defaultValue) {
        StringBuilder s = new StringBuilder();
        if (range.getLowerBound().isInclusive()) {
            s.append("[");
        } else {
            s.append("(");
        }
        if (!range.getLowerBound().getValue().isPresent() || range.getLowerBound().getValue().get().toString().isEmpty()) {
            s.append(defaultValue);
        } else {
            s.append(range.getLowerBound().getValue().get());
        }
        return s.toString();
    }

    String toLexUpperBound(Range range, Object defaultValue) {
        StringBuilder s = new StringBuilder();
        if (range.getUpperBound().isInclusive()) {
            s.append("[");
        } else {
            s.append("(");
        }
        if (!range.getUpperBound().getValue().isPresent() || range.getUpperBound().getValue().get().toString().isEmpty()) {
            s.append(defaultValue);
        } else {
            s.append(range.getUpperBound().getValue().get());
        }
        return s.toString();
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>> zCount(Publisher<ReactiveZSetCommands.ZCountCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZCOUNT, keyBuf, this.toLowerBound(command.getRange()), this.toUpperBound(command.getRange()));
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZCARD, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>> zScore(Publisher<ReactiveZSetCommands.ZScoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveZSetCommands.toByteArray(command.getValue());
            Mono m = this.read(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZSCORE, keyBuf, valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ReactiveZSetCommands.ZRemRangeByRankCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYRANK, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().get());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ReactiveZSetCommands.ZRemRangeByScoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYSCORE, keyBuf, this.toLowerBound(command.getRange()), this.toUpperBound(command.getRange()));
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>> zUnionStore(Publisher<? extends ReactiveZSetCommands.ZAggregateStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(keyBuf);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            Mono m = this.write(keyBuf, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)ZUNIONSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>> zInterStore(Publisher<? extends ReactiveZSetCommands.ZAggregateStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null!");
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(keyBuf);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            Mono m = this.write(keyBuf, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)ZINTERSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ReactiveZSetCommands.ZRangeByLexCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            String start = null;
            String end = null;
            if (command.getDirection() == Sort.Direction.ASC) {
                start = this.toLexLowerBound(command.getRange(), "-");
                end = this.toLexUpperBound(command.getRange(), "+");
            } else {
                start = this.toLexUpperBound(command.getRange(), "-");
                end = this.toLexLowerBound(command.getRange(), "+");
            }
            Mono m = !command.getLimit().isUnlimited() ? (command.getDirection() == Sort.Direction.ASC ? this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYLEX, keyBuf, start, end, "LIMIT", command.getLimit().getOffset(), command.getLimit().getCount()) : this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYLEX, keyBuf, start, end, "LIMIT", command.getLimit().getOffset(), command.getLimit().getCount())) : (command.getDirection() == Sort.Direction.ASC ? this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYLEX, keyBuf, start, end) : this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYLEX, keyBuf, start, end));
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(v -> ByteBuffer.wrap(v)));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LPosCommand, Long>> lPos(Publisher<ReactiveListCommands.LPosCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getElement(), (String)"Element must not be null!");
            ArrayList<Object> params = new ArrayList<Object>();
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            params.add(keyBuf);
            params.add(RedissonReactiveZSetCommands.toByteArray(command.getElement()));
            if (command.getRank() != null) {
                params.add("RANK");
                params.add(command.getRank());
            }
            if (command.getCount() != null) {
                params.add("COUNT");
                params.add(command.getCount());
            }
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand<?>)RedisCommands.LPOS, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZLexCountCommand, Long>> zLexCount(Publisher<ReactiveZSetCommands.ZLexCountCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            String start = this.toLexLowerBound(command.getRange(), "-");
            String end = this.toLexUpperBound(command.getRange(), "+");
            Mono m = this.read(keyBuf, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZLEXCOUNT, keyBuf, start, end);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByLexCommand, Long>> zRemRangeByLex(Publisher<ReactiveZSetCommands.ZRemRangeByLexCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getRange(), (String)"Range must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            String start = this.toLexLowerBound(command.getRange(), "-");
            String end = this.toLexUpperBound(command.getRange(), "+");
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYLEX, keyBuf, start, end);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZPopCommand, Flux<RedisZSetCommands.Tuple>>> zPop(Publisher<ReactiveZSetCommands.ZPopCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            RedisCommand<Set<RedisZSetCommands.Tuple>> cmd = ZPOPMAX;
            if (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN) {
                cmd = ZPOPMIN;
            }
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, cmd, keyBuf, command.getCount());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.BZPopCommand, Flux<RedisZSetCommands.Tuple>>> bZPop(Publisher<ReactiveZSetCommands.BZPopCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getTimeout(), (String)"Timeout must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            RedisCommand<Set<RedisZSetCommands.Tuple>> cmd = BZPOPMAX;
            if (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN) {
                cmd = BZPOPMIN;
            }
            long timeout = command.getTimeUnit().toSeconds(command.getTimeout());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, cmd, keyBuf, command.getCount(), timeout);
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux<ByteBuffer>>> zRandMember(Publisher<ReactiveZSetCommands.ZRandMemberCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZRANDMEMBER, keyBuf, command.getCount());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(v -> ByteBuffer.wrap(v)));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux<RedisZSetCommands.Tuple>>> zRandMemberWithScore(Publisher<ReactiveZSetCommands.ZRandMemberCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            Mono m = this.write(keyBuf, (Codec)ByteArrayCodec.INSTANCE, ZRANDMEMBER_SCORE, keyBuf, command.getCount(), "WITHSCORES");
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux<ByteBuffer>>> zDiff(Publisher<? extends ReactiveZSetCommands.ZDiffCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKeys(), (String)"Key must not be null!");
            ArrayList<Object> args = new ArrayList<Object>(command.getKeys().size() + 1);
            args.add(command.getKeys().size());
            for (ByteBuffer key : command.getKeys()) {
                args.add(RedissonReactiveZSetCommands.toByteArray(key));
            }
            Mono m = this.write(RedissonReactiveZSetCommands.toByteArray((ByteBuffer)command.getKeys().get(0)), (Codec)ByteArrayCodec.INSTANCE, (RedisCommand<?>)RedisCommands.ZDIFF, args.toArray());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(v -> ByteBuffer.wrap(v)));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux<RedisZSetCommands.Tuple>>> zDiffWithScores(Publisher<? extends ReactiveZSetCommands.ZDiffCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            ArrayList<Object> args = new ArrayList<Object>(command.getKeys().size() + 2);
            args.add(command.getKeys().size());
            for (ByteBuffer key : command.getKeys()) {
                args.add(RedissonReactiveZSetCommands.toByteArray(key));
            }
            args.add("WITHSCORES");
            Mono m = this.write(RedissonReactiveZSetCommands.toByteArray((ByteBuffer)command.getKeys().get(0)), (Codec)ByteArrayCodec.INSTANCE, ZDIFF_SCORE, args.toArray());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZDiffStoreCommand, Long>> zDiffStore(Publisher<ReactiveZSetCommands.ZDiffStoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getSourceKeys(), (String)"Source keys must not be null!");
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() + 2);
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            args.add(keyBuf);
            args.add(command.getSourceKeys().size());
            for (ByteBuffer key : command.getSourceKeys()) {
                args.add(RedissonReactiveZSetCommands.toByteArray(key));
            }
            Mono m = this.write(keyBuf, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZDIFFSTORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse(command, (Number)v));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<ByteBuffer>>> zUnion(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            Mono m = this.write(RedissonReactiveZSetCommands.toByteArray((ByteBuffer)command.getSourceKeys().get(0)), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZUNION, args.toArray());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(v -> ByteBuffer.wrap(v)));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<RedisZSetCommands.Tuple>>> zUnionWithScores(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            args.add("WITHSCORES");
            Mono m = this.write(RedissonReactiveZSetCommands.toByteArray((ByteBuffer)command.getSourceKeys().get(0)), (Codec)ByteArrayCodec.INSTANCE, ZUNION_SCORE, args.toArray());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<ByteBuffer>>> zInter(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            Mono m = this.write(RedissonReactiveZSetCommands.toByteArray((ByteBuffer)command.getSourceKeys().get(0)), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.ZINTER, args.toArray());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e).map(v -> ByteBuffer.wrap(v)));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<RedisZSetCommands.Tuple>>> zInterWithScores(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notEmpty((Collection)command.getSourceKeys(), (String)"Source keys must not be null or empty!");
            ArrayList<Object> args = new ArrayList<Object>(command.getSourceKeys().size() * 2 + 5);
            args.add(command.getSourceKeys().size());
            args.addAll(command.getSourceKeys().stream().map(e -> RedissonReactiveZSetCommands.toByteArray(e)).collect(Collectors.toList()));
            if (!command.getWeights().isEmpty()) {
                args.add("WEIGHTS");
                for (Double weight : command.getWeights()) {
                    args.add(BigDecimal.valueOf(weight).toPlainString());
                }
            }
            if (command.getAggregateFunction().isPresent()) {
                args.add("AGGREGATE");
                args.add(((RedisZSetCommands.Aggregate)command.getAggregateFunction().get()).name());
            }
            args.add("WITHSCORES");
            Mono m = this.write(RedissonReactiveZSetCommands.toByteArray((ByteBuffer)command.getSourceKeys().get(0)), (Codec)ByteArrayCodec.INSTANCE, ZINTER_SCORE, args.toArray());
            Flux flux = m.flatMapMany(e -> Flux.fromIterable((Iterable)e));
            return Mono.just((Object)new ReactiveRedisConnection.CommandResponse(command, (Object)flux));
        });
    }

    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveZSetCommands.ZMScoreCommand, Double>> zMScore(Publisher<ReactiveZSetCommands.ZMScoreCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null!");
            Assert.notNull((Object)command.getValues(), (String)"Values must not be null!");
            byte[] keyBuf = RedissonReactiveZSetCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getValues().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getValues().stream().map(buf -> RedissonReactiveZSetCommands.toByteArray(buf)).collect(Collectors.toList()));
            Mono m = this.read(keyBuf, (Codec)DoubleCodec.INSTANCE, ZMSCORE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.MultiValueResponse(command, v));
        });
    }
}

