/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.TimeLongObjectDecoder;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.PropertiesDecoder;
import org.redisson.spring.data.connection.PropertiesListDecoder;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveServerCommands;
import org.springframework.data.redis.core.types.RedisClientInfo;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveServerCommands
extends RedissonBaseReactive
implements ReactiveServerCommands {
    static final RedisStrictCommand<String> BGREWRITEAOF = new RedisStrictCommand("BGREWRITEAOF");
    static final RedisStrictCommand<String> BGSAVE = new RedisStrictCommand("BGSAVE");
    static final RedisStrictCommand<String> SAVE = new RedisStrictCommand("SAVE");
    private static final RedisStrictCommand<String> FLUSHDB = new RedisStrictCommand("FLUSHDB");
    private static final RedisStrictCommand<String> FLUSHALL = new RedisStrictCommand("FLUSHALL");
    static final RedisStrictCommand<Properties> INFO_DEFAULT = new RedisStrictCommand("INFO", "DEFAULT", (MultiDecoder)new ObjectDecoder((Decoder)new PropertiesDecoder()));
    static final RedisStrictCommand<Properties> INFO = new RedisStrictCommand("INFO", (MultiDecoder)new ObjectDecoder((Decoder)new PropertiesDecoder()));
    static final RedisStrictCommand<Properties> CONFIG_GET = new RedisStrictCommand("CONFIG", "GET", (MultiDecoder)new PropertiesListDecoder());
    static final RedisStrictCommand<String> CONFIG_SET = new RedisStrictCommand("CONFIG", "SET");
    static final RedisStrictCommand<String> CONFIG_RESETSTAT = new RedisStrictCommand("CONFIG", "RESETSTAT");
    static final RedisStrictCommand<Long> TIME = new RedisStrictCommand("TIME", (MultiDecoder)new TimeLongObjectDecoder());

    RedissonReactiveServerCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    public Mono<String> bgReWriteAof() {
        return this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BGREWRITEAOF, new Object[0]);
    }

    public Mono<String> bgSave() {
        return this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BGSAVE, new Object[0]);
    }

    public Mono<Long> lastSave() {
        return this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.LASTSAVE, new Object[0]);
    }

    public Mono<String> save() {
        return this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SAVE, new Object[0]);
    }

    public Mono<Long> dbSize() {
        return this.executorService.reactive(() -> {
            List futures = this.executorService.readAllAsync((RedisCommand)RedisCommands.DBSIZE, new Object[0]);
            CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            CompletionStage s = f.thenApply(r -> futures.stream().mapToLong(v -> v.getNow(0L)).sum());
            return new CompletableFutureWrapper((CompletableFuture)s);
        });
    }

    public Mono<String> flushDb() {
        return this.executorService.reactive(() -> {
            RFuture f = this.executorService.writeAllVoidAsync(FLUSHDB, new Object[0]);
            return this.toStringFuture((RFuture<Void>)f);
        });
    }

    public Mono<String> flushAll() {
        return this.executorService.reactive(() -> {
            RFuture f = this.executorService.writeAllVoidAsync(FLUSHALL, new Object[0]);
            return this.toStringFuture((RFuture<Void>)f);
        });
    }

    public Mono<Properties> info() {
        return this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO_DEFAULT, new Object[0]);
    }

    public Mono<Properties> info(String section) {
        return this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO, section);
    }

    public Mono<Properties> getConfig(String pattern) {
        return this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)CONFIG_GET, pattern);
    }

    public Mono<String> setConfig(String param, String value) {
        return this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)CONFIG_SET, param, value);
    }

    public Mono<String> resetConfigStats() {
        return this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)CONFIG_RESETSTAT, new Object[0]);
    }

    public Mono<Long> time() {
        return this.read(null, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)TIME, new Object[0]);
    }

    public Mono<String> killClient(String host, int port) {
        throw new UnsupportedOperationException();
    }

    public Mono<String> setClientName(String name) {
        throw new UnsupportedOperationException("Should be defined through Redisson Config object");
    }

    public Mono<String> getClientName() {
        throw new UnsupportedOperationException();
    }

    public Flux<RedisClientInfo> getClientList() {
        throw new UnsupportedOperationException();
    }
}

