/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.StringMapDataDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.spring.data.connection.RedisClusterNodeDecoder;
import org.redisson.spring.data.connection.RedissonConnection;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;

public class RedissonClusterConnection
extends RedissonConnection
implements RedisClusterConnection {
    private static final RedisStrictCommand<List<RedisClusterNode>> CLUSTER_NODES = new RedisStrictCommand("CLUSTER", "NODES", (MultiDecoder)new ObjectDecoder((Decoder)new RedisClusterNodeDecoder()));
    private static final RedisStrictCommand<List<String>> CLUSTER_GETKEYSINSLOT = new RedisStrictCommand("CLUSTER", "GETKEYSINSLOT", (MultiDecoder)new ObjectListReplayDecoder());
    private final RedisStrictCommand<List<byte[]>> KEYS = new RedisStrictCommand("KEYS");
    private static final StringToRedisClientInfoConverter CONVERTER = new StringToRedisClientInfoConverter();

    public RedissonClusterConnection(RedissonClient redisson) {
        super(redisson);
    }

    public Iterable<RedisClusterNode> clusterGetNodes() {
        return (Iterable)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)CLUSTER_NODES, new Object[0]);
    }

    public Collection<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        RedisClusterNode masterNode = null;
        for (RedisClusterNode redisClusterNode : res) {
            if (!master.getHost().equals(redisClusterNode.getHost()) || !master.getPort().equals(redisClusterNode.getPort())) continue;
            masterNode = redisClusterNode;
            break;
        }
        if (masterNode == null) {
            throw new IllegalStateException("Unable to find master node: " + master);
        }
        Iterator<RedisClusterNode> iterator = res.iterator();
        while (iterator.hasNext()) {
            RedisClusterNode redisClusterNode;
            redisClusterNode = iterator.next();
            if (redisClusterNode.getMasterId() != null && redisClusterNode.getMasterId().equals(masterNode.getId())) continue;
            iterator.remove();
        }
        return (Collection)res;
    }

    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        HashSet<RedisClusterNode> masters = new HashSet<RedisClusterNode>();
        for (RedisClusterNode redisClusterNode : res) {
            if (!redisClusterNode.isMaster()) continue;
            masters.add(redisClusterNode);
        }
        HashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new HashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (RedisClusterNode redisClusterNode : res) {
            for (RedisClusterNode masterNode : masters) {
                if (redisClusterNode.getMasterId() == null || !redisClusterNode.getMasterId().equals(masterNode.getId())) continue;
                ArrayList<RedisClusterNode> list = (ArrayList<RedisClusterNode>)result.get(masterNode);
                if (list == null) {
                    list = new ArrayList<RedisClusterNode>();
                    result.put(masterNode, list);
                }
                list.add(redisClusterNode);
            }
        }
        return result;
    }

    public Integer clusterGetSlotForKey(byte[] key) {
        RFuture f = this.executorService.readAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.KEYSLOT, new Object[]{key});
        return (Integer)this.syncFuture(f);
    }

    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        for (RedisClusterNode redisClusterNode : res) {
            if (!redisClusterNode.isMaster() || !redisClusterNode.getSlotRange().contains(slot)) continue;
            return redisClusterNode;
        }
        return null;
    }

    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        int slot = this.executorService.getConnectionManager().calcSlot(key);
        return this.clusterGetNodeForSlot(slot);
    }

    public ClusterInfo clusterGetClusterInfo() {
        RFuture f = this.executorService.readAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_INFO, new Object[0]);
        Map entries = (Map)this.syncFuture(f);
        Properties props = new Properties();
        for (Map.Entry entry : entries.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return new ClusterInfo(props);
    }

    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        MasterSlaveEntry entry = this.getEntry(node);
        List<Integer> params = this.convert(slots);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_ADDSLOTS, params.toArray());
        this.syncFuture(f);
    }

    protected List<Integer> convert(int ... slots) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        for (int slot : slots) {
            params.add(slot);
        }
        return params;
    }

    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    public Long clusterCountKeysInSlot(int slot) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(new InetSocketAddress(node.getHost(), (int)node.getPort()));
        RFuture f = this.executorService.readAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_COUNTKEYSINSLOT, new Object[]{slot});
        return (Long)this.syncFuture(f);
    }

    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        MasterSlaveEntry entry = this.getEntry(node);
        List<Integer> params = this.convert(slots);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_DELSLOTS, params.toArray());
        this.syncFuture(f);
    }

    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    public void clusterForget(RedisClusterNode node) {
        RFuture f = this.executorService.writeAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_FORGET, new Object[]{node.getId()});
        this.syncFuture(f);
    }

    public void clusterMeet(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command!");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host!");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0!");
        RFuture f = this.executorService.writeAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_MEET, new Object[]{node.getHost(), node.getPort()});
        this.syncFuture(f);
    }

    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_SETSLOT, new Object[]{slot, mode});
        this.syncFuture(f);
    }

    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        RFuture f = this.executorService.readAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, CLUSTER_GETKEYSINSLOT, new Object[]{slot, count});
        return (List)this.syncFuture(f);
    }

    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        MasterSlaveEntry entry = this.getEntry(master);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_REPLICATE, new Object[]{slave.getId()});
        this.syncFuture(f);
    }

    public String ping(RedisClusterNode node) {
        return (String)this.execute(node, RedisCommands.PING);
    }

    public void bgReWriteAof(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.BGREWRITEAOF);
    }

    public void bgSave(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.BGSAVE);
    }

    public Long lastSave(RedisClusterNode node) {
        return (Long)this.execute(node, (RedisCommand)RedisCommands.LASTSAVE);
    }

    public void save(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.SAVE);
    }

    public Long dbSize(RedisClusterNode node) {
        return (Long)this.execute(node, (RedisCommand)RedisCommands.DBSIZE);
    }

    private <T> T execute(RedisClusterNode node, RedisCommand<T> command) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, command, new Object[0]);
        return (T)this.syncFuture(f);
    }

    protected MasterSlaveEntry getEntry(RedisClusterNode node) {
        MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(new InetSocketAddress(node.getHost(), (int)node.getPort()));
        return entry;
    }

    public void flushDb(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.FLUSHDB);
    }

    public void flushAll(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.FLUSHALL);
    }

    public Properties info(RedisClusterNode node) {
        Map info = (Map)this.execute(node, (RedisCommand)RedisCommands.INFO_ALL);
        Properties result = new Properties();
        for (Map.Entry entry : info.entrySet()) {
            result.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public Properties info(RedisClusterNode node, String section) {
        RedisStrictCommand command = new RedisStrictCommand("INFO", section, (MultiDecoder)new StringMapDataDecoder());
        Map info = (Map)this.execute(node, (RedisCommand)command);
        Properties result = new Properties();
        for (Map.Entry entry : info.entrySet()) {
            result.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)ByteArrayCodec.INSTANCE, this.KEYS, new Object[]{pattern});
        Collection keys = (Collection)this.syncFuture(f);
        return new HashSet<byte[]>(keys);
    }

    public byte[] randomKey(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readRandomAsync(entry, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.RANDOM_KEY, new Object[0]);
        return (byte[])this.syncFuture(f);
    }

    public void shutdown(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.SHUTDOWN, new Object[0]);
        this.syncFuture(f);
    }

    public List<String> getConfig(RedisClusterNode node, String pattern) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CONFIG_GET, new Object[]{pattern});
        return (List)this.syncFuture(f);
    }

    public void setConfig(RedisClusterNode node, String param, String value) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CONFIG_SET, new Object[]{param, value});
        this.syncFuture(f);
    }

    public void resetConfigStats(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CONFIG_RESETSTAT, new Object[0]);
        this.syncFuture(f);
    }

    public Long time(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)LongCodec.INSTANCE, (RedisCommand)RedisCommands.TIME_LONG, new Object[0]);
        return (Long)this.syncFuture(f);
    }

    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLIENT_LIST, new Object[0]);
        List list = (List)this.syncFuture(f);
        return CONVERTER.convert(list.toArray(new String[list.size()]));
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        if (this.isPipelined()) {
            throw new InvalidDataAccessResourceUsageException("Clustered rename is not supported in a pipeline");
        }
        if (this.redisson.getConnectionManager().calcSlot(oldName) == this.redisson.getConnectionManager().calcSlot(newName)) {
            super.rename(oldName, newName);
            return;
        }
        byte[] value = this.dump(oldName);
        if (null != value) {
            Long sourceTtlInSeconds = this.ttl(oldName);
            long ttlInMilliseconds = null != sourceTtlInSeconds && sourceTtlInSeconds > 0L ? sourceTtlInSeconds * 1000L : 0L;
            this.restore(newName, ttlInMilliseconds, value);
            this.del(new byte[][]{oldName});
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        if (this.isPipelined()) {
            throw new InvalidDataAccessResourceUsageException("Clustered rename is not supported in a pipeline");
        }
        if (this.redisson.getConnectionManager().calcSlot(oldName) == this.redisson.getConnectionManager().calcSlot(newName)) {
            return super.renameNX(oldName, newName);
        }
        byte[] value = this.dump(oldName);
        if (null != value && !this.exists(newName).booleanValue()) {
            Long sourceTtlInSeconds = this.ttl(oldName);
            long ttlInMilliseconds = null != sourceTtlInSeconds && sourceTtlInSeconds > 0L ? sourceTtlInSeconds * 1000L : 0L;
            this.restore(newName, ttlInMilliseconds, value);
            this.del(new byte[][]{oldName});
            return true;
        }
        return false;
    }

    @Override
    public Long del(byte[] ... keys) {
        if (this.isQueueing() || this.isPipelined()) {
            for (byte[] key : keys) {
                this.write(key, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)RedisCommands.DEL, new Object[]{key});
            }
            return null;
        }
        CommandBatchService es = new CommandBatchService((CommandAsyncExecutor)this.executorService);
        for (byte[] key : keys) {
            es.writeAsync(key, (Codec)LongCodec.INSTANCE, (RedisCommand)RedisCommands.DEL, new Object[]{key});
        }
        BatchResult b = es.execute();
        return b.getResponses().stream().collect(Collectors.summarizingLong(v -> v)).getSum();
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        if (this.isQueueing() || this.isPipelined()) {
            for (byte[] key : keys) {
                this.read(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
            }
            return null;
        }
        CommandBatchService es = new CommandBatchService((CommandAsyncExecutor)this.executorService);
        for (byte[] key : keys) {
            es.readAsync(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
        }
        BatchResult r = es.execute();
        return r.getResponses();
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuple) {
        if (this.isQueueing() || this.isPipelined()) {
            for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
                this.write(entry.getKey(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, entry.getKey(), entry.getValue());
            }
            return;
        }
        CommandBatchService es = new CommandBatchService((CommandAsyncExecutor)this.executorService);
        for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
            es.writeAsync(entry.getKey(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, new Object[]{entry.getKey(), entry.getValue()});
        }
        es.execute();
    }
}

