/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.starter;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.config.BaseConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.misc.RedisURI;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.redisson.spring.starter.RedissonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.redis.autoconfigure.DataRedisAutoConfiguration;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionDetails;
import org.springframework.boot.data.redis.autoconfigure.DataRedisProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration(before={DataRedisAutoConfiguration.class})
@ConditionalOnClass(value={Redisson.class, RedisOperations.class, DataRedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedissonProperties.class, DataRedisProperties.class})
public class RedissonAutoConfigurationV4 {
    public static final String[] EMPTY = new String[0];
    @Autowired(required=false)
    private List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers;
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private DataRedisProperties redisProperties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={StringRedisTemplate.class})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedissonConnectionFactory redissonConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonReactiveClient.class})
    public RedissonReactiveClient redissonReactive(RedissonClient redisson) {
        return redisson.reactive();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonRxClient.class})
    public RedissonRxClient redissonRxJava(RedissonClient redisson) {
        return redisson.rxJava();
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redisson() throws IOException {
        Config config;
        String prefix = this.getPrefix();
        String username = this.redisProperties.getUsername();
        int database = this.redisProperties.getDatabase();
        String password = this.redisProperties.getPassword();
        String clientName = this.redisProperties.getClientName();
        boolean isSentinel = false;
        boolean isCluster = false;
        ObjectProvider provider = this.ctx.getBeanProvider(DataRedisConnectionDetails.class);
        DataRedisConnectionDetails connectionDetails = (DataRedisConnectionDetails)provider.getIfAvailable();
        if (connectionDetails != null) {
            password = connectionDetails.getPassword();
            username = connectionDetails.getUsername();
            isSentinel = connectionDetails.getSentinel() != null;
            boolean bl = isCluster = connectionDetails.getCluster() != null;
        }
        if (this.redissonProperties.getConfig() != null) {
            config = Config.fromYAML((String)this.redissonProperties.getConfig());
        } else if (this.redissonProperties.getFile() != null) {
            try (InputStream is = this.getConfigStream();){
                config = Config.fromYAML((InputStream)is);
            }
        } else {
            config = this.redisProperties.getSentinel() != null || isSentinel ? this.buildSentinelConfig(prefix, username, password, database, clientName, connectionDetails) : (this.redisProperties.getCluster() != null || isCluster ? this.buildClusterConfig(prefix, username, password, clientName, connectionDetails) : this.buildSingleServerConfig(prefix, username, password, database, clientName, connectionDetails));
        }
        if (this.redissonAutoConfigurationCustomizers != null) {
            for (RedissonAutoConfigurationCustomizer customizer : this.redissonAutoConfigurationCustomizers) {
                customizer.customize(config);
            }
        }
        return Redisson.create((Config)config);
    }

    private Config buildSentinelConfig(String prefix, String username, String password, int database, String clientName, DataRedisConnectionDetails connectionDetails) {
        String[] nodes;
        String sentinelMaster;
        DataRedisProperties.Sentinel sentinel;
        String sentinelUsername = null;
        String sentinelPassword = null;
        if (connectionDetails != null && connectionDetails.getSentinel() != null) {
            sentinel = connectionDetails.getSentinel();
            database = sentinel.getDatabase();
            sentinelMaster = sentinel.getMaster();
            nodes = this.convertNodes(prefix, sentinel.getNodes());
            sentinelUsername = sentinel.getUsername();
            sentinelPassword = sentinel.getPassword();
        } else {
            sentinel = this.redisProperties.getSentinel();
            if (sentinel != null) {
                nodes = this.convert(prefix, sentinel.getNodes());
                sentinelMaster = sentinel.getMaster();
            } else {
                nodes = EMPTY;
                sentinelMaster = null;
            }
        }
        Config config = new Config().setUsername(username).setPassword(password);
        SentinelServersConfig c = (SentinelServersConfig)config.useSentinelServers().setMasterName(sentinelMaster).addSentinelAddress(nodes).setSentinelPassword(sentinelPassword).setSentinelUsername(sentinelUsername).setDatabase(database).setClientName(clientName);
        this.setTimeouts((BaseConfig)c);
        this.initSSL(config);
        return config;
    }

    private Config buildClusterConfig(String prefix, String username, String password, String clientName, DataRedisConnectionDetails connectionDetails) {
        String[] nodes = connectionDetails != null && connectionDetails.getCluster() != null ? this.convertNodes(prefix, connectionDetails.getCluster().getNodes()) : this.convert(prefix, this.redisProperties.getCluster().getNodes());
        Config config = new Config().setUsername(username).setPassword(password);
        ClusterServersConfig c = (ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setClientName(clientName);
        this.setTimeouts((BaseConfig)c);
        this.initSSL(config);
        return config;
    }

    private Config buildSingleServerConfig(String prefix, String username, String password, int database, String clientName, DataRedisConnectionDetails connectionDetails) {
        String singleAddr;
        if (connectionDetails != null && connectionDetails.getStandalone() != null) {
            DataRedisConnectionDetails.Standalone standalone = connectionDetails.getStandalone();
            database = standalone.getDatabase();
            singleAddr = prefix + standalone.getHost() + ":" + standalone.getPort();
        } else {
            singleAddr = prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort();
        }
        Config config = new Config().setUsername(username).setPassword(password);
        SingleServerConfig c = (SingleServerConfig)config.useSingleServer().setAddress(singleAddr).setDatabase(database).setClientName(clientName);
        this.setTimeouts((BaseConfig)c);
        this.initSSL(config);
        return config;
    }

    private void setTimeouts(BaseConfig c) {
        if (this.redisProperties.getConnectTimeout() != null) {
            c.setConnectTimeout((int)this.redisProperties.getConnectTimeout().toMillis());
        }
        if (this.redisProperties.getTimeout() != null) {
            c.setTimeout((int)this.redisProperties.getTimeout().toMillis());
        }
    }

    private void initSSL(Config config) {
        DataRedisProperties.Ssl ssl = this.redisProperties.getSsl();
        if (ssl.getBundle() == null) {
            return;
        }
        ObjectProvider provider = this.ctx.getBeanProvider(SslBundles.class);
        SslBundles bundles = (SslBundles)provider.getIfAvailable();
        if (bundles == null) {
            return;
        }
        SslBundle bundle = bundles.getBundle(ssl.getBundle());
        config.setSslCiphers(bundle.getOptions().getCiphers());
        config.setSslProtocols(bundle.getOptions().getEnabledProtocols());
        config.setSslTrustManagerFactory(bundle.getManagers().getTrustManagerFactory());
        config.setSslKeyManagerFactory(bundle.getManagers().getKeyManagerFactory());
    }

    private String getPrefix() {
        DataRedisProperties.Ssl ssl = this.redisProperties.getSsl();
        if (ssl.isEnabled()) {
            return "rediss://";
        }
        return "redis://";
    }

    private String[] convertNodes(String prefix, List<?> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            for (Object node : nodesObject) {
                MethodType hostType = MethodType.methodType(String.class);
                MethodHandle hostHandle = lookup.findVirtual(node.getClass(), "host", hostType);
                String host = hostHandle.invoke(node);
                MethodType portType = MethodType.methodType(Integer.TYPE);
                MethodHandle portHandle = lookup.findVirtual(node.getClass(), "port", portType);
                int port = portHandle.invoke(node);
                nodes.add(prefix + host + ":" + port);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to convert nodes", e);
        }
        return nodes.toArray(new String[0]);
    }

    private String[] convert(String prefix, List<String> nodesObject) {
        if (nodesObject == null) {
            return EMPTY;
        }
        return (String[])nodesObject.stream().map(node -> {
            if (RedisURI.isValid((String)node)) {
                return node;
            }
            return prefix + node;
        }).toArray(String[]::new);
    }

    private InputStream getConfigStream() throws IOException {
        Resource resource = this.ctx.getResource(this.redissonProperties.getFile());
        return resource.getInputStream();
    }
}

