/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class KryoCodec
extends BaseCodec {
    private final KryoPool kryoPool;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Kryo kryo = null;
            try {
                kryo = KryoCodec.this.kryoPool.get();
                Object object = kryo.readClassAndObject(new Input(new ByteBufInputStream(buf)));
                return object;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RedissonKryoCodecException((Throwable)e);
            }
            finally {
                if (kryo != null) {
                    KryoCodec.this.kryoPool.yield(kryo);
                }
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            Kryo kryo = null;
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                Output output = new Output(baos);
                kryo = KryoCodec.this.kryoPool.get();
                kryo.writeClassAndObject(output, in);
                output.close();
                ByteBuf byteBuf = baos.buffer();
                if (kryo != null) {
                    KryoCodec.this.kryoPool.yield(kryo);
                }
                return byteBuf;
            }
            catch (Exception e) {
                try {
                    out.release();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RedissonKryoCodecException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (kryo != null) {
                        KryoCodec.this.kryoPool.yield(kryo);
                    }
                    throw throwable;
                }
            }
        }
    };

    public KryoCodec() {
        this(Collections.emptyList());
    }

    public KryoCodec(ClassLoader classLoader) {
        this(Collections.emptyList(), classLoader);
    }

    public KryoCodec(List<Class<?>> classes) {
        this(classes, null);
    }

    public KryoCodec(List<Class<?>> classes, ClassLoader classLoader) {
        this(new KryoPoolImpl(classes, classLoader));
    }

    public KryoCodec(KryoPool kryoPool) {
        this.kryoPool = kryoPool;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.kryoPool.getClassLoader() != null) {
            return this.kryoPool.getClassLoader();
        }
        return super.getClassLoader();
    }

    public class RedissonKryoCodecException
    extends RuntimeException {
        private static final long serialVersionUID = 9172336149805414947L;

        public RedissonKryoCodecException(Throwable cause) {
            super(cause.getMessage(), cause);
            this.setStackTrace(cause.getStackTrace());
        }
    }

    public static class KryoPoolImpl
    implements KryoPool {
        private final Queue<Kryo> objects = new ConcurrentLinkedQueue<Kryo>();
        private final List<Class<?>> classes;
        private final ClassLoader classLoader;

        public KryoPoolImpl(List<Class<?>> classes, ClassLoader classLoader) {
            this.classes = classes;
            this.classLoader = classLoader;
        }

        @Override
        public Kryo get() {
            Kryo kryo = this.objects.poll();
            if (kryo == null) {
                kryo = this.createInstance();
            }
            return kryo;
        }

        @Override
        public void yield(Kryo kryo) {
            this.objects.offer(kryo);
        }

        protected Kryo createInstance() {
            Kryo kryo = new Kryo();
            if (this.classLoader != null) {
                kryo.setClassLoader(this.classLoader);
            }
            kryo.setReferences(false);
            for (Class<?> clazz : this.classes) {
                kryo.register(clazz);
            }
            return kryo;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }

    public static interface KryoPool {
        public Kryo get();

        public void yield(Kryo var1);

        public ClassLoader getClassLoader();
    }
}

