/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Predicate;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.FluxRetryPredicate;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;

final class MonoRetryPredicate<T>
extends MonoOperator<T, T> {
    final Predicate<? super Throwable> predicate;

    MonoRetryPredicate(Mono<? extends T> source, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxRetryPredicate.RetryPredicateSubscriber<T> parent = new FluxRetryPredicate.RetryPredicateSubscriber<T>(this.source, actual, this.predicate);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }
}

