/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.executor.CronExpression;
import org.redisson.executor.RedissonClassLoader;
import org.redisson.executor.RemoteExecutorService;
import org.redisson.executor.RemoteExecutorServiceAsync;
import org.redisson.executor.ScheduledTasksService;
import org.redisson.misc.Injector;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;

public class TasksRunnerService
implements RemoteExecutorService {
    private final Codec codec;
    private final String name;
    private final CommandExecutor commandExecutor;
    private final RedissonClient redisson;
    private String tasksCounterName;
    private String statusName;
    private String terminationTopicName;
    private String tasksName;
    private String schedulerQueueName;
    private String schedulerChannelName;
    private String tasksRetryIntervalName;
    private ConcurrentMap<String, ResponseEntry> responses;

    public TasksRunnerService(CommandExecutor commandExecutor, RedissonClient redisson, Codec codec, String name, ConcurrentMap<String, ResponseEntry> responses) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.redisson = redisson;
        this.responses = responses;
        this.codec = codec;
    }

    public void setTasksRetryIntervalName(String tasksRetryInterval) {
        this.tasksRetryIntervalName = tasksRetryInterval;
    }

    public void setSchedulerQueueName(String schedulerQueueName) {
        this.schedulerQueueName = schedulerQueueName;
    }

    public void setSchedulerChannelName(String schedulerChannelName) {
        this.schedulerChannelName = schedulerChannelName;
    }

    public void setTasksName(String tasksName) {
        this.tasksName = tasksName;
    }

    public void setTasksCounterName(String tasksCounterName) {
        this.tasksCounterName = tasksCounterName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setTerminationTopicName(String terminationTopicName) {
        this.terminationTopicName = terminationTopicName;
    }

    @Override
    public void scheduleAtFixedRate(String className, byte[] classBody, byte[] state, long startTime, long period, String executorId, String requestId) {
        long newStartTime = System.currentTimeMillis() + period;
        RFuture<Void> future = this.asyncScheduledServiceAtFixed(executorId, requestId).scheduleAtFixedRate(className, classBody, state, newStartTime, period, executorId, requestId);
        try {
            this.executeRunnable(className, classBody, state, requestId);
        }
        catch (RuntimeException e) {
            future.cancel(true);
            throw e;
        }
    }

    @Override
    public void schedule(String className, byte[] classBody, byte[] state, long startTime, String cronExpression, String executorId, String requestId) {
        Date nextStartDate = new CronExpression(cronExpression).getNextValidTimeAfter(new Date());
        RFuture<Void> future = null;
        if (nextStartDate != null) {
            RemoteExecutorServiceAsync service = this.asyncScheduledServiceAtFixed(executorId, requestId);
            future = service.schedule(className, classBody, state, nextStartDate.getTime(), cronExpression, executorId, requestId);
        }
        try {
            this.executeRunnable(className, classBody, state, requestId);
        }
        catch (RuntimeException e) {
            if (future != null) {
                future.cancel(true);
            }
            throw e;
        }
    }

    private RemoteExecutorServiceAsync asyncScheduledServiceAtFixed(String executorId, String requestId) {
        ScheduledTasksService scheduledRemoteService = new ScheduledTasksService(this.codec, this.redisson, this.name, this.commandExecutor, executorId, this.responses);
        scheduledRemoteService.setTerminationTopicName(this.terminationTopicName);
        scheduledRemoteService.setTasksCounterName(this.tasksCounterName);
        scheduledRemoteService.setStatusName(this.statusName);
        scheduledRemoteService.setSchedulerQueueName(this.schedulerQueueName);
        scheduledRemoteService.setSchedulerChannelName(this.schedulerChannelName);
        scheduledRemoteService.setTasksName(this.tasksName);
        scheduledRemoteService.setRequestId(new RequestId(requestId));
        scheduledRemoteService.setTasksRetryIntervalName(this.tasksRetryIntervalName);
        RemoteExecutorServiceAsync asyncScheduledServiceAtFixed = scheduledRemoteService.get(RemoteExecutorServiceAsync.class, RemoteInvocationOptions.defaults().noAck().noResult());
        return asyncScheduledServiceAtFixed;
    }

    @Override
    public void scheduleWithFixedDelay(String className, byte[] classBody, byte[] state, long startTime, long delay, String executorId, String requestId) {
        this.executeRunnable(className, classBody, state, requestId);
        long newStartTime = System.currentTimeMillis() + delay;
        this.asyncScheduledServiceAtFixed(executorId, requestId).scheduleWithFixedDelay(className, classBody, state, newStartTime, delay, executorId, requestId);
    }

    @Override
    public Object scheduleCallable(String className, byte[] classBody, byte[] state, long startTime, String requestId) {
        return this.executeCallable(className, classBody, state, requestId);
    }

    @Override
    public void scheduleRunnable(String className, byte[] classBody, byte[] state, long startTime, String requestId) {
        this.executeRunnable(className, classBody, state, requestId);
    }

    @Override
    public Object executeCallable(String className, byte[] classBody, byte[] state, String requestId) {
        this.renewRetryTime(requestId);
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(state.length);
        try {
            buf.writeBytes(state);
            RedissonClassLoader cl = new RedissonClassLoader(this.codec.getClassLoader());
            cl.loadClass(className, classBody);
            Callable callable = (Callable)this.decode(cl, buf);
            Object v = callable.call();
            return v;
        }
        catch (RedissonShutdownException e) {
            Object var7_11 = null;
            return var7_11;
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            buf.release();
            this.finish(requestId);
        }
    }

    protected void scheduleRetryTimeRenewal(final String requestId) {
        ((Redisson)this.redisson).getConnectionManager().newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                TasksRunnerService.this.renewRetryTime(requestId);
            }
        }, 5L, TimeUnit.SECONDS);
    }

    protected void renewRetryTime(final String requestId) {
        RFuture future = this.commandExecutor.evalWriteAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local name = ARGV[2];local scheduledName = ARGV[2];if string.sub(scheduledName, 1, 2) ~= 'ff' then scheduledName = 'ff' .. scheduledName; else name = string.sub(name, 3, string.len(name)); end;local retryInterval = redis.call('get', KEYS[4]);if redis.call('exists', KEYS[1]) == 0 and retryInterval ~= false and redis.call('hexists', KEYS[5], name) == 1 then local startTime = tonumber(ARGV[1]) + tonumber(retryInterval);redis.call('zadd', KEYS[2], startTime, scheduledName);local v = redis.call('zrange', KEYS[2], 0, 0); if v[1] == ARGV[2] then redis.call('publish', KEYS[3], startTime); end;return 1; end;return 0;", Arrays.asList(this.statusName, this.schedulerQueueName, this.schedulerChannelName, this.tasksRetryIntervalName, this.tasksName), System.currentTimeMillis(), requestId);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess() || ((Boolean)future.get()).booleanValue()) {
                    TasksRunnerService.this.scheduleRetryTimeRenewal(requestId);
                }
            }
        });
    }

    private <T> T decode(RedissonClassLoader cl, ByteBuf buf) throws IOException {
        try {
            Codec codec = (Codec)this.codec.getClass().getConstructor(ClassLoader.class).newInstance(cl);
            Object task = codec.getValueDecoder().decode(buf, null);
            Injector.inject(task, this.redisson);
            return (T)task;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize codec with ClassLoader parameter", e);
        }
    }

    @Override
    public void executeRunnable(String className, byte[] classBody, byte[] state, String requestId) {
        if (requestId != null && requestId.startsWith("00")) {
            this.renewRetryTime(requestId);
        }
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(state.length);
        try {
            buf.writeBytes(state);
            RedissonClassLoader cl = new RedissonClassLoader(this.codec.getClassLoader());
            cl.loadClass(className, classBody);
            Runnable runnable = (Runnable)this.decode(cl, buf);
            runnable.run();
        }
        catch (RedissonShutdownException cl) {
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            buf.release();
            this.finish(requestId);
        }
    }

    private void finish(String requestId) {
        this.commandExecutor.evalWriteAsync(this.name, (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "local scheduled = redis.call('zscore', KEYS[5], ARGV[3]);if scheduled == false then redis.call('hdel', KEYS[4], ARGV[3]); end;redis.call('zrem', KEYS[5], 'ff' .. ARGV[3]);if redis.call('decr', KEYS[1]) == 0 then redis.call('del', KEYS[1], KEYS[6]);if redis.call('get', KEYS[2]) == ARGV[1] then redis.call('set', KEYS[2], ARGV[2]);redis.call('publish', KEYS[3], ARGV[2]);end;end;", Arrays.asList(this.tasksCounterName, this.statusName, this.terminationTopicName, this.tasksName, this.schedulerQueueName, this.tasksRetryIntervalName), 1, 2, requestId);
    }
}

