/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch.wait;

import java.util.concurrent.locks.LockSupport;
import reactor.jarjar.com.lmax.disruptor.AlertException;
import reactor.jarjar.com.lmax.disruptor.Sequence;
import reactor.jarjar.com.lmax.disruptor.SequenceBarrier;
import reactor.jarjar.com.lmax.disruptor.TimeoutException;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;

public class ParkWaitStrategy
implements WaitStrategy {
    private final long parkFor;

    public ParkWaitStrategy() {
        this(250L);
    }

    public ParkWaitStrategy(long parkFor) {
        this.parkFor = parkFor;
    }

    @Override
    public long waitFor(long sequence, Sequence cursor, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException, TimeoutException {
        long availableSequence;
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
            LockSupport.parkNanos(this.parkFor);
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
    }
}

