/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.RedisChannelInitializer;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.URIBuilder;

public class RedisClient {
    private final Bootstrap bootstrap;
    private final Bootstrap pubSubBootstrap;
    private final InetSocketAddress addr;
    private final ChannelGroup channels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE);
    private ExecutorService executor;
    private final long commandTimeout;
    private Timer timer;
    private boolean hasOwnGroup;
    private RedisClientConfig config;

    public static RedisClient create(RedisClientConfig config) {
        if (config.getTimer() == null) {
            config.setTimer(new HashedWheelTimer());
        }
        return new RedisClient(config);
    }

    private RedisClient(RedisClientConfig config) {
        this.config = config;
        this.executor = config.getExecutor();
        this.timer = config.getTimer();
        this.addr = new InetSocketAddress(config.getAddress().getHost(), config.getAddress().getPort());
        this.bootstrap = this.createBootstrap(config, RedisChannelInitializer.Type.PLAIN);
        this.pubSubBootstrap = this.createBootstrap(config, RedisChannelInitializer.Type.PUBSUB);
        this.commandTimeout = config.getCommandTimeout();
    }

    private Bootstrap createBootstrap(RedisClientConfig config, RedisChannelInitializer.Type type) {
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(config.getSocketChannelClass())).group(config.getGroup())).remoteAddress(this.addr);
        bootstrap.handler(new RedisChannelInitializer(bootstrap, config, this, this.channels, type));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, config.getConnectTimeout());
        return bootstrap;
    }

    @Deprecated
    public RedisClient(String address) {
        this(URIBuilder.create(address));
    }

    @Deprecated
    public RedisClient(URI address) {
        this(new HashedWheelTimer(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2), new NioEventLoopGroup(), address);
        this.hasOwnGroup = true;
    }

    @Deprecated
    public RedisClient(Timer timer, ExecutorService executor, EventLoopGroup group, URI address) {
        this(timer, executor, group, address.getHost(), address.getPort());
    }

    @Deprecated
    public RedisClient(String host, int port) {
        this(new HashedWheelTimer(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2), new NioEventLoopGroup(), NioSocketChannel.class, host, port, 10000, 10000);
        this.hasOwnGroup = true;
    }

    @Deprecated
    public RedisClient(Timer timer, ExecutorService executor, EventLoopGroup group, String host, int port) {
        this(timer, executor, group, NioSocketChannel.class, host, port, 10000, 10000);
    }

    @Deprecated
    public RedisClient(String host, int port, int connectTimeout, int commandTimeout) {
        this(new HashedWheelTimer(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2), new NioEventLoopGroup(), NioSocketChannel.class, host, port, connectTimeout, commandTimeout);
    }

    @Deprecated
    public RedisClient(Timer timer, ExecutorService executor, EventLoopGroup group, Class<? extends SocketChannel> socketChannelClass, String host, int port, int connectTimeout, int commandTimeout) {
        RedisClientConfig config = new RedisClientConfig();
        config.setTimer(timer).setExecutor(executor).setGroup(group).setSocketChannelClass(socketChannelClass).setAddress(host, port).setConnectTimeout(connectTimeout).setCommandTimeout(commandTimeout);
        this.config = config;
        this.executor = config.getExecutor();
        this.timer = config.getTimer();
        this.addr = new InetSocketAddress(config.getAddress().getHost(), config.getAddress().getPort());
        this.bootstrap = this.createBootstrap(config, RedisChannelInitializer.Type.PLAIN);
        this.pubSubBootstrap = this.createBootstrap(config, RedisChannelInitializer.Type.PUBSUB);
        this.commandTimeout = config.getCommandTimeout();
    }

    public String getIpAddr() {
        return this.addr.getAddress().getHostAddress() + ":" + this.addr.getPort();
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.bootstrap.config().group();
    }

    public RedisClientConfig getConfig() {
        return this.config;
    }

    public RedisConnection connect() {
        try {
            return this.connectAsync().syncUninterruptibly().getNow();
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.addr, e);
        }
    }

    public RFuture<RedisConnection> connectAsync() {
        final RedissonPromise<RedisConnection> f = new RedissonPromise<RedisConnection>();
        ChannelFuture channelFuture = this.bootstrap.connect();
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(final ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    final Object c = RedisConnection.getFrom(future.channel());
                    ((RedisConnection)c).getConnectionPromise().addListener(new FutureListener<RedisConnection>(){

                        @Override
                        public void operationComplete(final Future<RedisConnection> future) throws Exception {
                            RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (future.isSuccess()) {
                                        if (!f.trySuccess(c)) {
                                            c.closeAsync();
                                        }
                                    } else {
                                        f.tryFailure(future.cause());
                                        c.closeAsync();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                        @Override
                        public void run() {
                            f.tryFailure(future.cause());
                        }
                    });
                }
            }
        });
        return f;
    }

    public RedisPubSubConnection connectPubSub() {
        try {
            return this.connectPubSubAsync().syncUninterruptibly().getNow();
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.addr, e);
        }
    }

    public RFuture<RedisPubSubConnection> connectPubSubAsync() {
        final RedissonPromise<RedisPubSubConnection> f = new RedissonPromise<RedisPubSubConnection>();
        ChannelFuture channelFuture = this.pubSubBootstrap.connect();
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(final ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    final RedisPubSubConnection c = (RedisPubSubConnection)RedisPubSubConnection.getFrom(future.channel());
                    c.getConnectionPromise().addListener(new FutureListener<RedisPubSubConnection>(){

                        @Override
                        public void operationComplete(final Future<RedisPubSubConnection> future) throws Exception {
                            RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (future.isSuccess()) {
                                        if (!f.trySuccess(c)) {
                                            c.closeAsync();
                                        }
                                    } else {
                                        f.tryFailure(future.cause());
                                        c.closeAsync();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                        @Override
                        public void run() {
                            f.tryFailure(future.cause());
                        }
                    });
                }
            }
        });
        return f;
    }

    public void shutdown() {
        this.shutdownAsync().syncUninterruptibly();
        if (this.hasOwnGroup) {
            this.timer.stop();
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.bootstrap.config().group().shutdownGracefully();
        }
    }

    public ChannelGroupFuture shutdownAsync() {
        for (Channel channel : this.channels) {
            Object connection = RedisConnection.getFrom(channel);
            if (connection == null) continue;
            ((RedisConnection)connection).setClosed(true);
        }
        return this.channels.close();
    }

    public String toString() {
        return "[addr=" + this.addr + "]";
    }
}

