/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RoundRobinLoadBalancer;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandsLoadBalancer
extends RoundRobinLoadBalancer
implements LoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(CommandsLoadBalancer.class);
    private final Map<Pattern, Set<String>> commandsMap = new HashMap<Pattern, Set<String>>();
    private Set<String> commands;
    private RedisURI address;

    @Override
    public ClientConnectionsEntry getEntry(List<ClientConnectionsEntry> clientsCopy, RedisCommand<?> redisCommand) {
        String name = redisCommand.getName().toLowerCase(Locale.ENGLISH);
        if (this.commands != null && this.commands.contains(name)) {
            return clientsCopy.stream().filter((? super T c) -> this.address.equals(c.getClient().getAddr())).findAny().orElseGet(() -> this.getEntry(clientsCopy));
        }
        for (Map.Entry<Pattern, Set<String>> e : this.commandsMap.entrySet()) {
            List<ClientConnectionsEntry> s;
            if (!e.getValue().contains(name) || (s = this.filter(clientsCopy, e.getKey())).isEmpty()) continue;
            return this.getEntry(s);
        }
        return this.getEntry(clientsCopy);
    }

    @Deprecated
    public void setAddress(String address) {
        log.warn("address setting is deprecated. Use commandsMap setting instead.");
        this.address = new RedisURI(address);
    }

    @Deprecated
    public void setCommands(List<String> commands) {
        log.warn("commands setting is deprecated. Use commandsMap setting instead.");
        this.commands = commands.stream().map(c -> c.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
    }

    public void setCommandsMap(Map<String, Set<String>> value) {
        for (Map.Entry<String, Set<String>> e : value.entrySet()) {
            Set cc = e.getValue().stream().map(c -> c.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
            this.commandsMap.put(Pattern.compile(e.getKey()), cc);
        }
    }
}

