/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.convertor;

import java.math.BigDecimal;
import org.redisson.client.protocol.convertor.Convertor;

public class NumberConvertor
implements Convertor<Object> {
    private Class<?> resultClass;

    public NumberConvertor(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    @Override
    public Object convert(Object result) {
        String res = (String)result;
        if (this.resultClass.isAssignableFrom(Long.class)) {
            Long obj = Long.parseLong(res);
            return obj;
        }
        if (this.resultClass.isAssignableFrom(Integer.class)) {
            Integer obj = Integer.parseInt(res);
            return obj;
        }
        if (this.resultClass.isAssignableFrom(Float.class)) {
            Float obj = Float.valueOf(Float.parseFloat(res));
            return obj;
        }
        if (this.resultClass.isAssignableFrom(Double.class)) {
            Double obj = Double.parseDouble(res);
            return obj;
        }
        if (this.resultClass.isAssignableFrom(BigDecimal.class)) {
            BigDecimal obj = new BigDecimal(res);
            return obj;
        }
        throw new IllegalStateException("Wrong value type!");
    }
}

