/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.redisson.api.RBucketReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;

public class RedissonBucketReactive<V>
extends RedissonExpirableReactive
implements RBucketReactive<V> {
    public RedissonBucketReactive(CommandReactiveExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    public RedissonBucketReactive(Codec codec, CommandReactiveExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public Publisher<V> get() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.GET, this.getName());
    }

    @Override
    public Publisher<Void> set(V value) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SET, this.getName(), value);
    }

    @Override
    public Publisher<Void> set(V value, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.PSETEX, this.getName(), timeUnit.toMillis(timeToLive), value);
    }
}

