/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.combination;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Dispatcher;
import reactor.core.processor.CancelException;
import reactor.core.reactivestreams.SerializedSubscriber;
import reactor.core.support.Exceptions;
import reactor.core.support.NonBlocking;
import reactor.rx.action.Action;
import reactor.rx.broadcast.Broadcaster;

public class SwitchAction<T>
extends Action<Publisher<? extends T>, T> {
    private final Dispatcher dispatcher;
    private long pendingRequests = 0L;
    private SwitchSubscriber switchSubscriber;

    public SwitchAction(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public SwitchSubscriber getSwitchSubscriber() {
        return this.switchSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        boolean toSubscribe;
        SwitchSubscriber switcher;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            switcher = this.switchSubscriber;
            toSubscribe = switcher != null && switcher.s == null;
        }
        if (toSubscribe) {
            switcher.publisher.subscribe(switcher);
        }
        super.subscribe(SerializedSubscriber.create(subscriber));
    }

    @Override
    public void onNext(Publisher<? extends T> ev) {
        if (ev == null) {
            throw new NullPointerException("Spec 2.13: Signal cannot be null");
        }
        try {
            this.doNext(ev);
        }
        catch (CancelException uae) {
            throw uae;
        }
        catch (Throwable cause) {
            this.doError(Exceptions.addValueAsLastCause(cause, ev));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            subscriber = this.switchSubscriber;
        }
        if (subscriber != null) {
            subscriber.cancel();
        }
        if (this.upstreamSubscription != Broadcaster.HOT_SUBSCRIPTION) {
            super.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doNext(Publisher<? extends T> ev) {
        SwitchSubscriber nextSubscriber;
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            if (this.switchSubscriber != null && this.switchSubscriber.publisher == ev) {
                return;
            }
            if (this.pendingRequests != Long.MAX_VALUE) {
                --this.pendingRequests;
            }
            subscriber = this.switchSubscriber;
            this.switchSubscriber = nextSubscriber = new SwitchSubscriber(ev);
        }
        if (subscriber != null) {
            subscriber.cancel();
        }
        ev.subscribe(nextSubscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShutdown() {
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            subscriber = this.switchSubscriber;
            if (subscriber != null) {
                this.switchSubscriber = null;
            }
        }
        if (subscriber != null) {
            subscriber.cancel();
        }
        super.doShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComplete() {
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            subscriber = this.switchSubscriber;
        }
        if (subscriber == null) {
            super.doComplete();
        } else {
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void requestUpstream(long capacity, boolean terminated, long elements) {
        SwitchSubscriber subscriber;
        SwitchAction switchAction = this;
        synchronized (switchAction) {
            if ((this.pendingRequests += elements) < 0L) {
                this.pendingRequests = Long.MAX_VALUE;
            }
            subscriber = this.switchSubscriber;
        }
        super.requestUpstream(capacity, terminated, elements);
        if (subscriber != null) {
            subscriber.request(elements);
        }
    }

    @Override
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public class SwitchSubscriber
    implements NonBlocking,
    Subscriber<T>,
    Subscription {
        final Publisher<? extends T> publisher;
        Subscription s;

        public SwitchSubscriber(Publisher<? extends T> publisher) {
            this.publisher = publisher;
        }

        @Override
        public boolean isReactivePull(Dispatcher dispatcher, long producerCapacity) {
            return SwitchAction.this.isReactivePull(dispatcher, producerCapacity);
        }

        @Override
        public long getCapacity() {
            return SwitchAction.this.capacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribe(Subscription s) {
            long pending;
            this.s = s;
            SwitchAction switchAction = SwitchAction.this;
            synchronized (switchAction) {
                pending = SwitchAction.this.pendingRequests;
            }
            if (pending > 0L && SwitchAction.this.downstreamSubscription != null) {
                s.request(pending);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            SwitchAction switchAction = SwitchAction.this;
            synchronized (switchAction) {
                if (SwitchAction.this.pendingRequests > 0L && SwitchAction.this.pendingRequests != Long.MAX_VALUE) {
                    SwitchAction.this.pendingRequests--;
                }
            }
            SwitchAction.this.broadcastNext(t);
        }

        @Override
        public void onError(Throwable t) {
            SwitchAction.this.broadcastError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            SwitchAction switchAction = SwitchAction.this;
            synchronized (switchAction) {
                SwitchAction.this.switchSubscriber = null;
            }
            this.cancel();
            if (SwitchAction.this.upstreamSubscription == null) {
                SwitchAction.this.broadcastComplete();
            }
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            Subscription s = this.s;
            if (s != null) {
                this.s = null;
                s.cancel();
            }
        }

        public Subscription getSubscription() {
            return this.s;
        }
    }
}

