/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jodd.cache.AbstractCacheMap;

public class CacheValuesIterator<V>
implements Iterator<V> {
    private final Iterator<? extends AbstractCacheMap.CacheObject<?, V>> iterator;
    private AbstractCacheMap.CacheObject<?, V> nextValue;

    CacheValuesIterator(AbstractCacheMap<?, V> abstractCacheMap) {
        this.iterator = abstractCacheMap.cacheMap.values().iterator();
        this.nextValue();
    }

    private void nextValue() {
        while (this.iterator.hasNext()) {
            this.nextValue = this.iterator.next();
            if (this.nextValue.isExpired()) continue;
            return;
        }
        this.nextValue = null;
    }

    @Override
    public boolean hasNext() {
        return this.nextValue != null;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object cachedObject = this.nextValue.cachedObject;
        this.nextValue();
        return (V)cachedObject;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

