/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.DecoderState;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ListMultiDecoder<T>
implements MultiDecoder<Object> {
    private final MultiDecoder<?>[] decoders;

    protected final NestedDecoderState getDecoder(State state) {
        NestedDecoderState ds = (NestedDecoderState)state.getDecoderState();
        if (ds == null) {
            ds = new NestedDecoderState();
            state.setDecoderState(ds);
        }
        return ds;
    }

    public ListMultiDecoder(MultiDecoder<?> ... decoders) {
        this.decoders = decoders;
    }

    @Override
    public Object decode(ByteBuf buf, State state) throws IOException {
        int index = this.getDecoder(state).getIndex();
        return this.decoders[index].decode(buf, state);
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        if (paramNum == 0) {
            NestedDecoderState s = this.getDecoder(state);
            s.incIndex();
            s.resetPartsIndex();
        }
        return true;
    }

    @Override
    public Object decode(List<Object> parts, State state) {
        NestedDecoderState s = this.getDecoder(state);
        int index = s.getIndex();
        Object res = this.decoders[index += s.incPartsIndex()].decode(parts, state);
        if (res == null) {
            index = s.incIndex() + s.getPartsIndex();
            return this.decoders[index].decode(parts, state);
        }
        return res;
    }

    public static class NestedDecoderState
    implements DecoderState {
        int index = -1;
        int partsIndex = -1;

        public NestedDecoderState() {
        }

        public NestedDecoderState(int index) {
            this.index = index;
        }

        public void resetPartsIndex() {
            this.partsIndex = -1;
        }

        public int incPartsIndex() {
            return ++this.partsIndex;
        }

        public int getPartsIndex() {
            return this.partsIndex;
        }

        public int incIndex() {
            return ++this.index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public DecoderState copy() {
            return new NestedDecoderState(this.index);
        }

        public String toString() {
            return "NestedDecoderState [index=" + this.index + "]";
        }
    }
}

