/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent.builder;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.Map;
import net.bytebuddy.agent.builder.AgentBuilder;

public interface ResettableClassFileTransformer
extends ClassFileTransformer {
    public Reset reset(Instrumentation var1, AgentBuilder.RedefinitionStrategy var2);

    public static interface Reset {
        public boolean isApplied();

        public Map<Class<?>, Throwable> getErrors();

        public static class WithErrors
        implements Reset {
            private final Map<Class<?>, Throwable> errors;

            protected WithErrors(Map<Class<?>, Throwable> errors) {
                this.errors = errors;
            }

            public static Reset ofPotentiallyErroneous(Map<Class<?>, Throwable> errors) {
                return errors.isEmpty() ? Simple.ACTIVE : new WithErrors(errors);
            }

            @Override
            public boolean isApplied() {
                return true;
            }

            @Override
            public Map<Class<?>, Throwable> getErrors() {
                return this.errors;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WithErrors that = (WithErrors)object;
                return this.errors.equals(that.errors);
            }

            public int hashCode() {
                return this.errors.hashCode();
            }

            public String toString() {
                return "ResettableClassFileTransformer.Reset.WithErrors{errors=" + this.errors + '}';
            }
        }

        public static enum Simple implements Reset
        {
            ACTIVE(true),
            INACTIVE(false);

            private final boolean alive;

            private Simple(boolean alive) {
                this.alive = alive;
            }

            @Override
            public boolean isApplied() {
                return this.alive;
            }

            @Override
            public Map<Class<?>, Throwable> getErrors() {
                return Collections.emptyMap();
            }

            public String toString() {
                return "ResettableClassFileTransformer.Reset.Simple." + this.name();
            }
        }
    }
}

