/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import org.redisson.config.BaseConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.balancer.LoadBalancer;
import org.redisson.connection.balancer.RoundRobinLoadBalancer;

public class BaseMasterSlaveServersConfig<T extends BaseMasterSlaveServersConfig<T>>
extends BaseConfig<T> {
    private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
    private int slaveSubscriptionConnectionMinimumIdleSize = 1;
    private int slaveSubscriptionConnectionPoolSize = 50;
    private int slaveConnectionMinimumIdleSize = 10;
    private int slaveConnectionPoolSize = 64;
    private int masterConnectionMinimumIdleSize = 10;
    private int masterConnectionPoolSize = 64;
    private ReadMode readMode = ReadMode.SLAVE;

    public BaseMasterSlaveServersConfig() {
    }

    BaseMasterSlaveServersConfig(T config) {
        super(config);
        this.setLoadBalancer(((BaseMasterSlaveServersConfig)config).getLoadBalancer());
        this.setMasterConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getMasterConnectionPoolSize());
        this.setSlaveConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getSlaveConnectionPoolSize());
        this.setSlaveSubscriptionConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getSlaveSubscriptionConnectionPoolSize());
        this.setMasterConnectionMinimumIdleSize(((BaseMasterSlaveServersConfig)config).getMasterConnectionMinimumIdleSize());
        this.setSlaveConnectionMinimumIdleSize(((BaseMasterSlaveServersConfig)config).getSlaveConnectionMinimumIdleSize());
        this.setSlaveSubscriptionConnectionMinimumIdleSize(((BaseMasterSlaveServersConfig)config).getSlaveSubscriptionConnectionMinimumIdleSize());
        this.setReadMode(((BaseMasterSlaveServersConfig)config).getReadMode());
    }

    public T setSlaveConnectionPoolSize(int slaveConnectionPoolSize) {
        this.slaveConnectionPoolSize = slaveConnectionPoolSize;
        return (T)this;
    }

    public int getSlaveConnectionPoolSize() {
        return this.slaveConnectionPoolSize;
    }

    public T setMasterConnectionPoolSize(int masterConnectionPoolSize) {
        this.masterConnectionPoolSize = masterConnectionPoolSize;
        return (T)this;
    }

    public int getMasterConnectionPoolSize() {
        return this.masterConnectionPoolSize;
    }

    public T setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return (T)this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public T setSlaveSubscriptionConnectionPoolSize(int slaveSubscriptionConnectionPoolSize) {
        this.slaveSubscriptionConnectionPoolSize = slaveSubscriptionConnectionPoolSize;
        return (T)this;
    }

    public int getSlaveSubscriptionConnectionPoolSize() {
        return this.slaveSubscriptionConnectionPoolSize;
    }

    public T setSlaveConnectionMinimumIdleSize(int slaveConnectionMinimumIdleSize) {
        this.slaveConnectionMinimumIdleSize = slaveConnectionMinimumIdleSize;
        return (T)this;
    }

    public int getSlaveConnectionMinimumIdleSize() {
        return this.slaveConnectionMinimumIdleSize;
    }

    public T setMasterConnectionMinimumIdleSize(int masterConnectionMinimumIdleSize) {
        this.masterConnectionMinimumIdleSize = masterConnectionMinimumIdleSize;
        return (T)this;
    }

    public int getMasterConnectionMinimumIdleSize() {
        return this.masterConnectionMinimumIdleSize;
    }

    public T setSlaveSubscriptionConnectionMinimumIdleSize(int slaveSubscriptionConnectionMinimumIdleSize) {
        this.slaveSubscriptionConnectionMinimumIdleSize = slaveSubscriptionConnectionMinimumIdleSize;
        return (T)this;
    }

    public int getSlaveSubscriptionConnectionMinimumIdleSize() {
        return this.slaveSubscriptionConnectionMinimumIdleSize;
    }

    public T setReadMode(ReadMode readMode) {
        this.readMode = readMode;
        return (T)this;
    }

    public ReadMode getReadMode() {
        return this.readMode;
    }
}

