/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class ByteArrayCodec
implements Codec {
    public static final ByteArrayCodec INSTANCE = new ByteArrayCodec();
    private final Encoder encoder = new Encoder(){

        @Override
        public byte[] encode(Object in) throws IOException {
            return (byte[])in;
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) {
            byte[] result = new byte[buf.readableBytes()];
            buf.readBytes(result);
            return result;
        }
    };

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }
}

