/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.connection.pool.PubSubConnectionPool;
import org.redisson.connection.pool.SinglePubSubConnectionPool;
import org.redisson.misc.RPromise;

public class SingleEntry
extends MasterSlaveEntry {
    final PubSubConnectionPool pubSubConnectionHolder;

    public SingleEntry(Set<ClusterSlotRange> slotRanges, ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        super(slotRanges, connectionManager, config);
        this.pubSubConnectionHolder = new SinglePubSubConnectionPool(config, connectionManager, this);
    }

    @Override
    public RFuture<Void> setupMasterEntry(String host, int port) {
        RedisClient masterClient = this.connectionManager.createClient(NodeType.MASTER, host, port);
        this.masterEntry = new ClientConnectionsEntry(masterClient, this.config.getMasterConnectionMinimumIdleSize(), this.config.getMasterConnectionPoolSize(), this.config.getSlaveConnectionMinimumIdleSize(), this.config.getSlaveSubscriptionConnectionPoolSize(), this.connectionManager, NodeType.MASTER);
        final RPromise<Void> res = this.connectionManager.newPromise();
        RFuture f = this.writeConnectionHolder.add(this.masterEntry);
        RFuture s = this.pubSubConnectionHolder.add(this.masterEntry);
        FutureListener<Void> listener = new FutureListener<Void>(){
            AtomicInteger counter = new AtomicInteger(2);

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    res.tryFailure(future.cause());
                    return;
                }
                if (this.counter.decrementAndGet() == 0) {
                    res.trySuccess(null);
                }
            }
        };
        f.addListener(listener);
        s.addListener(listener);
        return res;
    }

    @Override
    RFuture<RedisPubSubConnection> nextPubSubConnection() {
        return this.pubSubConnectionHolder.get();
    }

    @Override
    public void returnPubSubConnection(PubSubConnectionEntry entry) {
        this.pubSubConnectionHolder.returnConnection(this.masterEntry, entry.getConnection());
    }

    @Override
    public RFuture<RedisConnection> connectionReadOp(InetSocketAddress addr) {
        return super.connectionWriteOp();
    }

    @Override
    public RFuture<RedisConnection> connectionReadOp() {
        return super.connectionWriteOp();
    }

    @Override
    public void releaseRead(RedisConnection connection) {
        super.releaseWrite(connection);
    }
}

