/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import java.lang.reflect.Constructor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.NullValue;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class RedissonCache
implements Cache {
    private RMapCache<Object, Object> mapCache;
    private final RMap<Object, Object> map;
    private CacheConfig config;
    private final boolean allowNullValues;
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();

    public RedissonCache(RMapCache<Object, Object> mapCache, CacheConfig config, boolean allowNullValues) {
        this.mapCache = mapCache;
        this.map = mapCache;
        this.config = config;
        this.allowNullValues = allowNullValues;
    }

    public RedissonCache(RMap<Object, Object> map, boolean allowNullValues) {
        this.map = map;
        this.allowNullValues = allowNullValues;
    }

    public String getName() {
        return this.map.getName();
    }

    public RMap<?, ?> getNativeCache() {
        return this.map;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.map.get(key);
        if (value == null) {
            this.addCacheMiss();
        } else {
            this.addCacheHit();
        }
        return this.toValueWrapper(value);
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.map.get(key);
        if (value == null) {
            this.addCacheMiss();
        } else {
            this.addCacheHit();
            if (value.getClass().getName().equals(NullValue.class.getName())) {
                return null;
            }
            if (type != null && !type.isInstance(value)) {
                throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
            }
        }
        return (T)this.fromStoreValue(value);
    }

    public void put(Object key, Object value) {
        if (!this.allowNullValues && value == null) {
            if (this.mapCache != null) {
                this.mapCache.remove(key);
            } else {
                this.map.remove(key);
            }
            return;
        }
        value = this.toStoreValue(value);
        if (this.mapCache != null) {
            this.mapCache.fastPut(key, value, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        } else {
            this.map.fastPut(key, value);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object prevValue;
        if (!this.allowNullValues && value == null) {
            prevValue = this.mapCache != null ? this.mapCache.get(key) : this.map.get(key);
        } else {
            value = this.toStoreValue(value);
            prevValue = this.mapCache != null ? this.mapCache.putIfAbsent(key, value, this.config.getTTL(), TimeUnit.MILLISECONDS, this.config.getMaxIdleTime(), TimeUnit.MILLISECONDS) : this.map.putIfAbsent(key, value);
        }
        return this.toValueWrapper(prevValue);
    }

    public void evict(Object key) {
        this.map.fastRemove((Object[])new Object[]{key});
    }

    public void clear() {
        this.map.clear();
    }

    private Cache.ValueWrapper toValueWrapper(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().getName().equals(NullValue.class.getName())) {
            return NullValue.INSTANCE;
        }
        return new SimpleValueWrapper(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T get(Object key, Callable<T> valueLoader) {
        void var3_7;
        Object v = this.map.get(key);
        if (v == null) {
            this.addCacheMiss();
            RLock lock = this.map.getLock(key);
            lock.lock();
            try {
                Object object;
                Object v2 = this.map.get(key);
                if (v2 != null) return (T)this.fromStoreValue(var3_7);
                try {
                    object = this.toStoreValue(valueLoader.call());
                }
                catch (Exception ex) {
                    try {
                        Class<?> c = Class.forName("org.springframework.cache.Cache$ValueRetrievalException");
                        Constructor<?> constructor = c.getConstructor(Object.class, Callable.class, Throwable.class);
                        RuntimeException exception = (RuntimeException)constructor.newInstance(key, valueLoader, ex.getCause());
                        throw exception;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.put(key, object);
                return (T)this.fromStoreValue(var3_7);
            }
            finally {
                lock.unlock();
            }
        }
        this.addCacheHit();
        return (T)this.fromStoreValue(var3_7);
    }

    protected Object fromStoreValue(Object storeValue) {
        if (storeValue instanceof NullValue) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (userValue == null) {
            return NullValue.INSTANCE;
        }
        return userValue;
    }

    long getCacheHits() {
        return this.hits.get();
    }

    long getCacheMisses() {
        return this.misses.get();
    }

    private void addCacheHit() {
        this.hits.incrementAndGet();
    }

    private void addCacheMiss() {
        this.misses.incrementAndGet();
    }
}

