/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.misc.URLBuilder;

public class MasterSlaveServersConfig
extends BaseMasterSlaveServersConfig<MasterSlaveServersConfig> {
    private Set<URL> slaveAddresses = new HashSet<URL>();
    private URL masterAddress;
    private int database = 0;

    public MasterSlaveServersConfig() {
    }

    MasterSlaveServersConfig(MasterSlaveServersConfig config) {
        super(config);
        this.setLoadBalancer(config.getLoadBalancer());
        this.setMasterAddress(config.getMasterAddress());
        this.setSlaveAddresses(config.getSlaveAddresses());
        this.setDatabase(config.getDatabase());
    }

    public MasterSlaveServersConfig setMasterAddress(String masterAddress) {
        if (masterAddress != null) {
            this.masterAddress = URLBuilder.create(masterAddress);
        }
        return this;
    }

    public URL getMasterAddress() {
        if (this.masterAddress != null) {
            return this.masterAddress;
        }
        return null;
    }

    public void setMasterAddress(URL masterAddress) {
        if (masterAddress != null) {
            this.masterAddress = masterAddress;
        }
    }

    public MasterSlaveServersConfig addSlaveAddress(String ... addresses) {
        for (String address : addresses) {
            this.slaveAddresses.add(URLBuilder.create(address));
        }
        return this;
    }

    public MasterSlaveServersConfig addSlaveAddress(URL slaveAddress) {
        this.slaveAddresses.add(slaveAddress);
        return this;
    }

    public Set<URL> getSlaveAddresses() {
        return this.slaveAddresses;
    }

    public void setSlaveAddresses(Set<URL> readAddresses) {
        this.slaveAddresses = readAddresses;
    }

    public MasterSlaveServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }
}

