/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import org.redisson.cache.CachedValue;

public class StdCachedValue<K, V>
implements CachedValue<K, V> {
    protected final K key;
    protected final V value;
    long ttl;
    long maxIdleTime;
    long creationTime;
    long lastAccess;

    public StdCachedValue(K key, V value, long ttl, long maxIdleTime) {
        this.value = value;
        this.ttl = ttl;
        this.key = key;
        this.maxIdleTime = maxIdleTime;
        this.lastAccess = this.creationTime = System.currentTimeMillis();
    }

    @Override
    public boolean isExpired() {
        boolean result = false;
        long currentTime = System.currentTimeMillis();
        if (this.ttl != 0L && this.creationTime + this.ttl < currentTime) {
            result = true;
        }
        if (this.maxIdleTime != 0L && this.lastAccess + this.maxIdleTime < currentTime) {
            result = true;
        }
        return result;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        this.lastAccess = System.currentTimeMillis();
        return this.value;
    }

    public String toString() {
        return "CachedValue [key=" + this.key + ", value=" + this.value + "]";
    }
}

