/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import java.util.List;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.redisson.misc.URLBuilder;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class RedissonDefinitionParser
implements BeanDefinitionParser {
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    private static final String REF_SUFFIX = "-ref";
    private static final String REDISSON_REF = "redisson-ref";
    private final RedissonNamespaceParserSupport helper;

    RedissonDefinitionParser(RedissonNamespaceParserSupport helper) {
        this.helper = helper;
    }

    private void parseChildElements(Element element, String parentId, String redissonRef, BeanDefinitionBuilder redissonDef, ParserContext parserContext) {
        if (element.hasChildNodes()) {
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(parentId, parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            List childElts = DomUtils.getChildElements((Element)element);
            for (Element elt : childElts) {
                if ("qualifier".equals(elt.getLocalName())) continue;
                String localName = parserContext.getDelegate().getLocalName((Node)elt);
                if (ConfigType.contains(localName = Conventions.attributeNameToPropertyName((String)localName))) {
                    this.parseConfigTypes(elt, localName, redissonDef, parserContext);
                    continue;
                }
                if (AddressType.contains(localName)) {
                    this.parseAddressTypes(elt, localName, redissonDef, parserContext);
                    continue;
                }
                if (!this.helper.isRedissonNS(elt)) continue;
                elt.setAttribute(REDISSON_REF, redissonRef);
                parserContext.getDelegate().parseCustomElement(elt);
            }
            parserContext.popContainingComponent();
        }
    }

    private void parseConfigTypes(Element element, String configType, BeanDefinitionBuilder redissonDef, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.helper.createBeanDefinitionBuilder(element, parserContext, null);
        AbstractBeanDefinition bd = builder.getRawBeanDefinition();
        bd.setFactoryMethodName("use" + StringUtils.capitalize((String)configType));
        bd.setFactoryBeanName(parserContext.getContainingComponent().getName());
        String id = parserContext.getReaderContext().generateBeanName((BeanDefinition)bd);
        this.helper.registerBeanDefinition(builder, id, this.helper.parseAliase(element), parserContext);
        this.parseAttributes(element, parserContext, builder);
        redissonDef.addDependsOn(id);
        this.parseChildElements(element, id, null, redissonDef, parserContext);
        parserContext.getDelegate().parseQualifierElements(element, bd);
    }

    private void parseAddressTypes(Element element, String addressType, BeanDefinitionBuilder redissonDef, ParserContext parserContext) {
        BeanComponentDefinition invoker = this.helper.invoker(element, parserContext.getContainingComponent().getName(), "add" + StringUtils.capitalize((String)addressType), (Object[])new String[]{element.getAttribute("value")}, parserContext);
        String id = invoker.getName();
        redissonDef.addDependsOn(id);
    }

    private void parseAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            if (!this.helper.isEligibleAttribute(attribute)) continue;
            String propertyName = attribute.getLocalName().endsWith(REF_SUFFIX) ? attribute.getLocalName().substring(0, attribute.getLocalName().length() - REF_SUFFIX.length()) : attribute.getLocalName();
            propertyName = Conventions.attributeNameToPropertyName((String)propertyName);
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            if (attribute.getLocalName().endsWith(REF_SUFFIX)) {
                builder.addPropertyReference(propertyName, attribute.getValue());
                continue;
            }
            Object value = attribute.getValue();
            String localName = this.helper.getName(element);
            if ("masterAddress".equals(propertyName) && ConfigType.masterSlaveServers.name().equals(localName)) {
                try {
                    value = URLBuilder.create((String)value);
                }
                catch (Exception e) {
                    value = "redis://" + value;
                }
            }
            builder.addPropertyValue(propertyName, value);
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder configBuilder = this.helper.createBeanDefinitionBuilder(element, parserContext, Config.class);
        String configId = this.helper.getId(null, configBuilder, parserContext);
        this.parseAttributes(element, parserContext, configBuilder);
        this.helper.registerBeanDefinition(configBuilder, configId, null, parserContext);
        BeanDefinitionBuilder builder = this.helper.createBeanDefinitionBuilder(element, parserContext, Redisson.class);
        builder.setFactoryMethod("create");
        builder.setDestroyMethodName("shutdown");
        builder.addConstructorArgReference(configId);
        parserContext.getDelegate().parseQualifierElements(element, builder.getRawBeanDefinition());
        String id = this.helper.getId(element, builder, parserContext);
        this.parseAttributes(element, parserContext, configBuilder);
        this.parseChildElements(element, configId, id, builder, parserContext);
        this.helper.registerBeanDefinition(builder, id, this.helper.parseAliase(element), parserContext);
        return builder.getBeanDefinition();
    }

    static enum AddressType {
        slaveAddress,
        sentinelAddress,
        nodeAddress;


        public static boolean contains(String type) {
            try {
                AddressType.valueOf(type);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    static enum ConfigType {
        singleServer,
        sentinelServers,
        replicatedServers,
        masterSlaveServers,
        clusterServers;


        public static boolean contains(String type) {
            try {
                ConfigType.valueOf(type);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

