/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.lang.ref.ReferenceQueue;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;
import org.redisson.cache.CachedValueReference;
import org.redisson.cache.SoftCachedValue;

public class SoftCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public SoftCacheMap(long timeToLiveInMillis, long maxIdleInMillis) {
        super(0, timeToLiveInMillis, maxIdleInMillis);
    }

    @Override
    protected CachedValue<K, V> create(K key, V value, long ttl, long maxIdleTime) {
        return new SoftCachedValue<K, V>(key, value, ttl, maxIdleTime, this.queue);
    }

    @Override
    protected boolean removeExpiredEntries() {
        CachedValueReference value;
        while ((value = (CachedValueReference)this.queue.poll()) != null) {
            this.map.remove(value.getOwner().getKey(), value.getOwner());
        }
        return super.removeExpiredEntries();
    }

    @Override
    protected void onMapFull() {
    }
}

