/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;

public class LRUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final Queue<CachedValue> queue = new ConcurrentLinkedQueue<CachedValue>();

    public LRUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
    }

    @Override
    protected void onValueCreate(CachedValue value) {
        this.queue.add(value);
    }

    @Override
    protected void onValueRemove(CachedValue value) {
        this.queue.remove(value);
    }

    @Override
    protected void onValueRead(CachedValue value) {
        if (this.queue.remove(value)) {
            this.queue.add(value);
        }
    }

    @Override
    protected void onMapFull() {
        CachedValue value = this.queue.poll();
        if (value != null) {
            this.map.remove(value.getKey(), value);
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }
}

