/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.support;

import java.util.HashSet;
import reactor.core.support.ReactorFatalException;

public final class Exceptions {
    private static final int MAX_DEPTH = 25;

    public static void addCause(Throwable e, Throwable cause) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return;
            }
            if (seenCauses.contains((e = e.getCause()).getCause())) break;
            seenCauses.add(e.getCause());
        }
        try {
            e.initCause(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Object getFinalValueCause(Throwable e) {
        Throwable t = Exceptions.getFinalCause(e);
        if (ValueCause.class.isAssignableFrom(t.getClass())) {
            return ((ValueCause)t).getValue();
        }
        return null;
    }

    public static Throwable getFinalCause(Throwable e) {
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            e = e.getCause();
        }
        return e;
    }

    public static Throwable addValueAsLastCause(Throwable e, Object value) {
        Throwable lastCause = Exceptions.getFinalCause(e);
        if (lastCause != null && lastCause instanceof ValueCause && ((ValueCause)lastCause).getValue() == value) {
            return e;
        }
        Exceptions.addCause(e, new ValueCause(value));
        return e;
    }

    public static void throwIfFatal(Throwable t) {
        if (t instanceof ReactorFatalException) {
            throw (ReactorFatalException)t;
        }
        if (t instanceof StackOverflowError) {
            throw (StackOverflowError)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    public static class ValueCause
    extends RuntimeException {
        private static final long serialVersionUID = -3454462756050397899L;
        private final Object value;

        public ValueCause(Object value) {
            super("Exception while signaling value: " + ValueCause.renderValue(value));
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        private static String renderValue(Object value) {
            if (value == null) {
                return "null";
            }
            if (value.getClass().isPrimitive()) {
                return value.toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            return value.getClass().getName() + ".class : " + value;
        }
    }
}

