/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.UnsafeMemoryInput;
import com.esotericsoftware.kryo.io.UnsafeMemoryOutput;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;
import reactor.io.codec.SerializationCodec;

public class KryoPoolCodec<IN, OUT>
extends SerializationCodec<KryoPool, IN, OUT> {
    public KryoPoolCodec() {
        this(new KryoFactory(){

            @Override
            public Kryo create() {
                return new Kryo();
            }
        }, true);
    }

    public KryoPoolCodec(KryoFactory kryoFactory, boolean lengthFieldFraming) {
        this(new KryoPool.Builder(kryoFactory).softReferences().build(), lengthFieldFraming);
    }

    public KryoPoolCodec(KryoPool engine, boolean lengthFieldFraming) {
        super(engine, lengthFieldFraming);
    }

    @Override
    protected Function<byte[], IN> deserializer(final KryoPool engine, final Class<IN> type, final Consumer<IN> next) {
        return new Function<byte[], IN>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IN apply(byte[] bytes) {
                Kryo kryo = engine.borrow();
                try {
                    Object obj = kryo.readObject(new UnsafeMemoryInput(bytes), type);
                    if (null != next) {
                        next.accept(obj);
                        Object IN = null;
                        return IN;
                    }
                    Object t = obj;
                    return t;
                }
                finally {
                    engine.release(kryo);
                }
            }
        };
    }

    @Override
    protected Function<OUT, byte[]> serializer(final KryoPool engine) {
        return new Function<OUT, byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] apply(OUT o) {
                Kryo kryo = engine.borrow();
                try {
                    UnsafeMemoryOutput out = new UnsafeMemoryOutput(Buffer.SMALL_BUFFER_SIZE, Buffer.MAX_BUFFER_SIZE);
                    kryo.writeObject(out, o);
                    out.flush();
                    byte[] byArray = out.toBytes();
                    return byArray;
                }
                finally {
                    engine.release(kryo);
                }
            }
        };
    }
}

