/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.cluster.ClusterConnectionListener;
import org.redisson.cluster.ClusterNodeInfo;
import org.redisson.cluster.ClusterPartition;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.CRC16;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.SingleEntry;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<URI, RedisConnection> nodeConnections = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<Integer, ClusterPartition> lastPartitions = PlatformDependent.newConcurrentHashMap();
    private ScheduledFuture<?> monitorFuture;
    private volatile URI lastClusterNode;

    public ClusterConnectionManager(ClusterServersConfig cfg, Config config) {
        super(config);
        this.connectListener = new ClusterConnectionListener(cfg.getReadMode() != ReadMode.MASTER);
        this.config = this.create(cfg);
        this.init(this.config);
        Throwable lastException = null;
        ArrayList<String> failedMasters = new ArrayList<String>();
        for (URI addr : cfg.getNodeAddresses()) {
            RFuture<RedisConnection> connectionFuture = this.connect(cfg, addr);
            try {
                RedisConnection connection = connectionFuture.syncUninterruptibly().getNow();
                List<ClusterNodeInfo> nodes = connection.sync(RedisCommands.CLUSTER_NODES, new Object[0]);
                if (this.log.isDebugEnabled()) {
                    StringBuilder nodesValue = new StringBuilder();
                    for (ClusterNodeInfo clusterNodeInfo : nodes) {
                        nodesValue.append(clusterNodeInfo.getNodeInfo()).append("\n");
                    }
                    this.log.debug("cluster nodes state from {}:\n{}", (Object)connection.getRedisClient().getAddr(), (Object)nodesValue);
                }
                this.lastClusterNode = addr;
                Collection<ClusterPartition> partitions = this.parsePartitions(nodes);
                ArrayList<RFuture<Collection<RFuture<Void>>>> futures = new ArrayList<RFuture<Collection<RFuture<Void>>>>();
                for (ClusterPartition clusterPartition : partitions) {
                    if (clusterPartition.isMasterFail()) {
                        failedMasters.add(clusterPartition.getMasterAddr().toString());
                        continue;
                    }
                    RFuture<Collection<RFuture<Void>>> masterFuture = this.addMasterEntry(clusterPartition, cfg);
                    futures.add(masterFuture);
                }
                for (RFuture rFuture : futures) {
                    rFuture.awaitUninterruptibly();
                    if (!rFuture.isSuccess()) {
                        lastException = rFuture.cause();
                        continue;
                    }
                    for (RFuture future : (Collection)rFuture.getNow()) {
                        future.awaitUninterruptibly();
                        if (future.isSuccess()) continue;
                        lastException = future.cause();
                    }
                }
                break;
            }
            catch (Exception e) {
                lastException = e;
                this.log.warn(e.getMessage());
            }
        }
        if (this.lastPartitions.isEmpty()) {
            this.stopThreads();
            if (failedMasters.isEmpty()) {
                throw new RedisConnectionException("Can't connect to servers!", lastException);
            }
            throw new RedisConnectionException("Can't connect to servers! Failed masters according to cluster status: " + failedMasters, lastException);
        }
        if (this.lastPartitions.size() != 16384) {
            this.stopThreads();
            if (failedMasters.isEmpty()) {
                throw new RedisConnectionException("Not all slots are covered! Only " + this.lastPartitions.size() + " slots are avaliable", lastException);
            }
            throw new RedisConnectionException("Not all slots are covered! Only " + this.lastPartitions.size() + " slots are avaliable. Failed masters according to cluster status: " + failedMasters, lastException);
        }
        this.scheduleClusterChangeCheck(cfg, null);
    }

    private void close(RedisConnection conn) {
        if (this.nodeConnections.values().remove(conn)) {
            conn.closeAsync();
        }
    }

    private RFuture<RedisConnection> connect(ClusterServersConfig cfg, final URI addr) {
        RedisConnection connection = this.nodeConnections.get(addr);
        if (connection != null) {
            return this.newSucceededFuture(connection);
        }
        RedisClient client = this.createClient(addr.getHost(), addr.getPort(), cfg.getConnectTimeout(), cfg.getRetryInterval() * cfg.getRetryAttempts());
        final RPromise<RedisConnection> result = this.newPromise();
        RFuture<RedisConnection> future = client.connectAsync();
        future.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                RedisConnection connection = future.getNow();
                RPromise promise = ClusterConnectionManager.this.newPromise();
                ClusterConnectionManager.this.connectListener.onConnect(promise, connection, null, ClusterConnectionManager.this.config);
                promise.addListener(new FutureListener<RedisConnection>(){

                    @Override
                    public void operationComplete(Future<RedisConnection> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedisConnection connection = future.getNow();
                        if (connection.isActive()) {
                            ClusterConnectionManager.this.nodeConnections.put(addr, connection);
                            result.trySuccess(connection);
                        } else {
                            connection.closeAsync();
                            result.tryFailure(new RedisException("Connection to " + connection.getRedisClient().getAddr() + " is not active!"));
                        }
                    }
                });
            }
        });
        return result;
    }

    @Override
    protected void initEntry(MasterSlaveServersConfig config) {
    }

    private RFuture<Collection<RFuture<Void>>> addMasterEntry(final ClusterPartition partition, final ClusterServersConfig cfg) {
        if (partition.isMasterFail()) {
            RedisException e = new RedisException("Failed to add master: " + partition.getMasterAddress() + " for slot ranges: " + partition.getSlotRanges() + ". Reason - server has FAIL flag");
            if (partition.getSlotRanges().isEmpty()) {
                e = new RedisException("Failed to add master: " + partition.getMasterAddress() + ". Reason - server has FAIL flag");
            }
            return this.newFailedFuture(e);
        }
        final RPromise<Collection<RFuture<Void>>> result = this.newPromise();
        RFuture<RedisConnection> connectionFuture = this.connect(cfg, partition.getMasterAddress());
        connectionFuture.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    ClusterConnectionManager.this.log.error("Can't connect to master: {} with slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                    result.tryFailure(future.cause());
                    return;
                }
                final RedisConnection connection = future.getNow();
                RFuture clusterFuture = connection.async(RedisCommands.CLUSTER_INFO, new Object[0]);
                clusterFuture.addListener(new FutureListener<Map<String, String>>(){

                    @Override
                    public void operationComplete(Future<Map<String, String>> future) throws Exception {
                        MasterSlaveEntry e;
                        if (!future.isSuccess()) {
                            ClusterConnectionManager.this.log.error("Can't execute CLUSTER_INFO for " + connection.getRedisClient().getAddr(), future.cause());
                            result.tryFailure(future.cause());
                            return;
                        }
                        Map<String, String> params = future.getNow();
                        if ("fail".equals(params.get("cluster_state"))) {
                            RedisException e2 = new RedisException("Failed to add master: " + partition.getMasterAddress() + " for slot ranges: " + partition.getSlotRanges() + ". Reason - cluster_state:fail");
                            ClusterConnectionManager.this.log.error("cluster_state:fail for " + connection.getRedisClient().getAddr());
                            result.tryFailure(e2);
                            return;
                        }
                        MasterSlaveServersConfig config = ClusterConnectionManager.this.create(cfg);
                        config.setMasterAddress(partition.getMasterAddress());
                        ArrayList<RFuture<Void>> futures = new ArrayList<RFuture<Void>>();
                        if (config.getReadMode() == ReadMode.MASTER) {
                            e = new SingleEntry(partition.getSlotRanges(), ClusterConnectionManager.this, config);
                        } else {
                            config.setSlaveAddresses(partition.getSlaveAddresses());
                            e = new MasterSlaveEntry(partition.getSlotRanges(), ClusterConnectionManager.this, config);
                            List<RFuture<Void>> fs = e.initSlaveBalancer(partition.getFailedSlaveAddresses());
                            futures.addAll(fs);
                            if (!partition.getSlaveAddresses().isEmpty()) {
                                ClusterConnectionManager.this.log.info("slaves: {} added for slot ranges: {}", (Object)partition.getSlaveAddresses(), (Object)partition.getSlotRanges());
                                if (!partition.getFailedSlaveAddresses().isEmpty()) {
                                    ClusterConnectionManager.this.log.warn("slaves: {} is down for slot ranges: {}", (Object)partition.getFailedSlaveAddresses(), (Object)partition.getSlotRanges());
                                }
                            }
                        }
                        RFuture<Void> f = e.setupMasterEntry(config.getMasterAddress().getHost(), config.getMasterAddress().getPort());
                        final RPromise initFuture = ClusterConnectionManager.this.newPromise();
                        futures.add(initFuture);
                        f.addListener(new FutureListener<Void>(){

                            @Override
                            public void operationComplete(Future<Void> future) throws Exception {
                                if (!future.isSuccess()) {
                                    ClusterConnectionManager.this.log.error("Can't add master: {} for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                                    initFuture.tryFailure(future.cause());
                                    return;
                                }
                                for (Integer slot : partition.getSlots()) {
                                    ClusterConnectionManager.this.addEntry(slot, e);
                                    ClusterConnectionManager.this.lastPartitions.put(slot, partition);
                                }
                                ClusterConnectionManager.this.log.info("master: {} added for slot ranges: {}", (Object)partition.getMasterAddress(), (Object)partition.getSlotRanges());
                                if (!initFuture.trySuccess(null)) {
                                    throw new IllegalStateException();
                                }
                            }
                        });
                        if (!result.trySuccess(futures)) {
                            throw new IllegalStateException();
                        }
                    }
                });
            }
        });
        return result;
    }

    private void scheduleClusterChangeCheck(final ClusterServersConfig cfg, final Iterator<URI> iterator) {
        this.monitorFuture = GlobalEventExecutor.INSTANCE.schedule(new Runnable(){

            @Override
            public void run() {
                AtomicReference lastException = new AtomicReference();
                Iterator nodesIterator = iterator;
                if (nodesIterator == null) {
                    ArrayList<URI> nodes = new ArrayList<URI>();
                    ArrayList<URI> slaves = new ArrayList<URI>();
                    for (ClusterPartition partition : ClusterConnectionManager.this.getLastPartitions()) {
                        if (!partition.isMasterFail()) {
                            nodes.add(partition.getMasterAddress());
                        }
                        HashSet<URI> partitionSlaves = new HashSet<URI>(partition.getSlaveAddresses());
                        partitionSlaves.removeAll(partition.getFailedSlaveAddresses());
                        slaves.addAll(partitionSlaves);
                    }
                    nodes.addAll(slaves);
                    nodesIterator = nodes.iterator();
                }
                ClusterConnectionManager.this.checkClusterState(cfg, nodesIterator, lastException);
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkClusterState(final ClusterServersConfig cfg, final Iterator<URI> iterator, final AtomicReference<Throwable> lastException) {
        if (!iterator.hasNext()) {
            this.log.error("Can't update cluster state", lastException.get());
            this.scheduleClusterChangeCheck(cfg, null);
            return;
        }
        final URI uri = iterator.next();
        RFuture<RedisConnection> connectionFuture = this.connect(cfg, uri);
        connectionFuture.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> future) throws Exception {
                if (!future.isSuccess()) {
                    lastException.set(future.cause());
                    ClusterConnectionManager.this.checkClusterState(cfg, iterator, lastException);
                    return;
                }
                RedisConnection connection = future.getNow();
                ClusterConnectionManager.this.updateClusterState(cfg, connection, iterator, uri);
            }
        });
    }

    private void updateClusterState(final ClusterServersConfig cfg, final RedisConnection connection, final Iterator<URI> iterator, final URI uri) {
        RFuture future = connection.async(RedisCommands.CLUSTER_NODES, new Object[0]);
        future.addListener(new FutureListener<List<ClusterNodeInfo>>(){

            @Override
            public void operationComplete(Future<List<ClusterNodeInfo>> future) throws Exception {
                if (!future.isSuccess()) {
                    ClusterConnectionManager.this.log.error("Can't execute CLUSTER_NODES with " + connection.getRedisClient().getAddr(), future.cause());
                    ClusterConnectionManager.this.close(connection);
                    ClusterConnectionManager.this.scheduleClusterChangeCheck(cfg, iterator);
                    return;
                }
                ClusterConnectionManager.this.lastClusterNode = uri;
                List<ClusterNodeInfo> nodes = future.getNow();
                final StringBuilder nodesValue = new StringBuilder();
                if (ClusterConnectionManager.this.log.isDebugEnabled()) {
                    for (ClusterNodeInfo clusterNodeInfo : nodes) {
                        nodesValue.append(clusterNodeInfo.getNodeInfo()).append("\n");
                    }
                    ClusterConnectionManager.this.log.debug("cluster nodes state from {}:\n{}", (Object)connection.getRedisClient().getAddr(), (Object)nodesValue);
                }
                final Collection newPartitions = ClusterConnectionManager.this.parsePartitions(nodes);
                RFuture masterFuture = ClusterConnectionManager.this.checkMasterNodesChange(cfg, newPartitions);
                ClusterConnectionManager.this.checkSlaveNodesChange(newPartitions);
                masterFuture.addListener(new FutureListener<Void>(){

                    @Override
                    public void operationComplete(Future<Void> future) throws Exception {
                        ClusterConnectionManager.this.checkSlotsMigration(newPartitions, nodesValue.toString());
                        ClusterConnectionManager.this.checkSlotsChange(cfg, newPartitions, nodesValue.toString());
                        ClusterConnectionManager.this.scheduleClusterChangeCheck(cfg, null);
                    }
                });
            }
        });
    }

    private void checkSlaveNodesChange(Collection<ClusterPartition> newPartitions) {
        block0: for (ClusterPartition newPart : newPartitions) {
            for (ClusterPartition currentPart : this.getLastPartitions()) {
                if (!newPart.getMasterAddress().equals(currentPart.getMasterAddress())) continue;
                MasterSlaveEntry entry = this.getEntry(currentPart.getMasterAddr());
                Set<URI> addedSlaves = this.addRemoveSlaves(entry, currentPart, newPart);
                this.upDownSlaves(entry, currentPart, newPart, addedSlaves);
                continue block0;
            }
        }
    }

    private void upDownSlaves(MasterSlaveEntry entry, ClusterPartition currentPart, ClusterPartition newPart, Set<URI> addedSlaves) {
        HashSet<URI> aliveSlaves = new HashSet<URI>(currentPart.getFailedSlaveAddresses());
        aliveSlaves.removeAll(addedSlaves);
        aliveSlaves.removeAll(newPart.getFailedSlaveAddresses());
        for (URI uri : aliveSlaves) {
            currentPart.removeFailedSlaveAddress(uri);
            if (!entry.slaveUp(uri.getHost(), uri.getPort(), ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
            this.log.info("slave: {} has up for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
        }
        HashSet<URI> failedSlaves = new HashSet<URI>(newPart.getFailedSlaveAddresses());
        failedSlaves.removeAll(currentPart.getFailedSlaveAddresses());
        for (URI uri : failedSlaves) {
            currentPart.addFailedSlaveAddress(uri);
            if (!entry.slaveDown(uri.getHost(), uri.getPort(), ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
            this.log.warn("slave: {} has down for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
        }
    }

    private Set<URI> addRemoveSlaves(final MasterSlaveEntry entry, final ClusterPartition currentPart, ClusterPartition newPart) {
        HashSet<URI> removedSlaves = new HashSet<URI>(currentPart.getSlaveAddresses());
        removedSlaves.removeAll(newPart.getSlaveAddresses());
        for (URI uri : removedSlaves) {
            currentPart.removeSlaveAddress(uri);
            if (!entry.slaveDown(uri.getHost(), uri.getPort(), ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
            this.log.info("slave {} removed for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
        }
        HashSet<URI> addedSlaves = new HashSet<URI>(newPart.getSlaveAddresses());
        addedSlaves.removeAll(currentPart.getSlaveAddresses());
        for (final URI uri : addedSlaves) {
            RFuture<Void> future = entry.addSlave(uri.getHost(), uri.getPort());
            future.addListener(new FutureListener<Void>(){

                @Override
                public void operationComplete(Future<Void> future) throws Exception {
                    if (!future.isSuccess()) {
                        ClusterConnectionManager.this.log.error("Can't add slave: " + uri, future.cause());
                        return;
                    }
                    currentPart.addSlaveAddress(uri);
                    entry.slaveUp(uri.getHost(), uri.getPort(), ClientConnectionsEntry.FreezeReason.MANAGER);
                    ClusterConnectionManager.this.log.info("slave: {} added for slot ranges: {}", (Object)uri, (Object)currentPart.getSlotRanges());
                }
            });
        }
        return addedSlaves;
    }

    private Collection<Integer> slots(Collection<ClusterPartition> partitions) {
        HashSet<Integer> result = new HashSet<Integer>(16384);
        for (ClusterPartition clusterPartition : partitions) {
            result.addAll(clusterPartition.getSlots());
        }
        return result;
    }

    private ClusterPartition find(Collection<ClusterPartition> partitions, Integer slot) {
        for (ClusterPartition clusterPartition : partitions) {
            for (ClusterSlotRange slotRange : clusterPartition.getSlotRanges()) {
                if (!slotRange.isOwn(slot)) continue;
                return clusterPartition;
            }
        }
        return null;
    }

    private RFuture<Void> checkMasterNodesChange(ClusterServersConfig cfg, Collection<ClusterPartition> newPartitions) {
        ArrayList<ClusterPartition> newMasters = new ArrayList<ClusterPartition>();
        for (ClusterPartition newPart : newPartitions) {
            boolean masterFound = false;
            for (ClusterPartition currentPart : this.getLastPartitions()) {
                if (!newPart.getMasterAddress().equals(currentPart.getMasterAddress())) continue;
                masterFound = true;
                if (!newPart.isMasterFail()) continue;
                for (Integer slot : currentPart.getSlots()) {
                    ClusterPartition newMasterPart = this.find(newPartitions, slot);
                    if (newMasterPart.getMasterAddress().equals(currentPart.getMasterAddress())) continue;
                    this.log.info("changing master from {} to {} for {}", currentPart.getMasterAddress(), newMasterPart.getMasterAddress(), slot);
                    URI newUri = newMasterPart.getMasterAddress();
                    URI oldUri = currentPart.getMasterAddress();
                    this.changeMaster(slot, newUri.getHost(), newUri.getPort());
                    currentPart.setMasterAddress(newMasterPart.getMasterAddress());
                }
            }
            if (masterFound || newPart.getSlotRanges().isEmpty()) continue;
            newMasters.add(newPart);
        }
        if (newMasters.isEmpty()) {
            return this.newSucceededFuture(null);
        }
        final RPromise<Void> result = this.newPromise();
        final AtomicInteger masters = new AtomicInteger(newMasters.size());
        final ConcurrentLinkedQueue futures = new ConcurrentLinkedQueue();
        for (ClusterPartition newPart : newMasters) {
            RFuture<Collection<RFuture<Void>>> future = this.addMasterEntry(newPart, cfg);
            future.addListener(new FutureListener<Collection<RFuture<Void>>>(){

                @Override
                public void operationComplete(Future<Collection<RFuture<Void>>> future) throws Exception {
                    if (future.isSuccess()) {
                        futures.addAll(future.getNow());
                    }
                    if (masters.decrementAndGet() == 0) {
                        final AtomicInteger nodes = new AtomicInteger(futures.size());
                        for (RFuture nodeFuture : futures) {
                            nodeFuture.addListener(new FutureListener<Void>(){

                                @Override
                                public void operationComplete(Future<Void> future) throws Exception {
                                    if (nodes.decrementAndGet() == 0) {
                                        result.trySuccess(null);
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
        return result;
    }

    private void checkSlotsChange(ClusterServersConfig cfg, Collection<ClusterPartition> newPartitions, String nodes) {
        Collection<Integer> newPartitionsSlots = this.slots(newPartitions);
        if (newPartitionsSlots.size() == this.lastPartitions.size() && this.lastPartitions.size() == 16384) {
            return;
        }
        HashSet removedSlots = new HashSet(this.lastPartitions.keySet());
        removedSlots.removeAll(newPartitionsSlots);
        this.lastPartitions.keySet().removeAll(removedSlots);
        if (!removedSlots.isEmpty()) {
            this.log.info("{} slots found to remove", (Object)removedSlots.size());
        }
        for (Integer slot : removedSlots) {
            MasterSlaveEntry entry = this.removeMaster(slot);
            entry.removeSlotRange(slot);
            if (!entry.getSlotRanges().isEmpty()) continue;
            entry.shutdownMasterAsync();
            this.log.info("{} master and slaves for it removed", (Object)entry.getClient().getAddr());
        }
        HashSet<Integer> addedSlots = new HashSet<Integer>(newPartitionsSlots);
        addedSlots.removeAll(this.lastPartitions.keySet());
        if (!addedSlots.isEmpty()) {
            this.log.info("{} slots found to add", (Object)addedSlots.size());
        }
        block1: for (Integer slot : addedSlots) {
            ClusterPartition partition = this.find(newPartitions, slot);
            for (MasterSlaveEntry entry : this.getEntrySet()) {
                if (!entry.getClient().getAddr().equals(partition.getMasterAddr())) continue;
                this.addEntry(slot, entry);
                this.lastPartitions.put(slot, partition);
                continue block1;
            }
        }
    }

    private void checkSlotsMigration(Collection<ClusterPartition> newPartitions, String nodes) {
        HashSet<ClusterPartition> currentPartitions = this.getLastPartitions();
        block0: for (ClusterPartition currentPartition : currentPartitions) {
            for (ClusterPartition newPartition : newPartitions) {
                if (!currentPartition.getNodeId().equals(newPartition.getNodeId()) || !currentPartition.getMasterAddr().equals(newPartition.getMasterAddr())) continue;
                HashSet<Integer> addedSlots = new HashSet<Integer>(newPartition.getSlots());
                addedSlots.removeAll(currentPartition.getSlots());
                currentPartition.addSlots(addedSlots);
                MasterSlaveEntry entry = this.getEntry(currentPartition.getMasterAddr());
                for (Integer slot : addedSlots) {
                    entry.addSlotRange(slot);
                    this.addEntry(slot, entry);
                    this.lastPartitions.put(slot, currentPartition);
                }
                if (!addedSlots.isEmpty()) {
                    this.log.info("{} slots added to {}", (Object)addedSlots.size(), (Object)currentPartition.getMasterAddr());
                }
                HashSet<Integer> removedSlots = new HashSet<Integer>(currentPartition.getSlots());
                removedSlots.removeAll(newPartition.getSlots());
                for (Integer removeSlot : removedSlots) {
                    if (!this.lastPartitions.remove(removeSlot, currentPartition)) continue;
                    entry.removeSlotRange(removeSlot);
                    this.removeMaster(removeSlot);
                }
                currentPartition.removeSlots(removedSlots);
                if (removedSlots.isEmpty()) continue block0;
                this.log.info("{} slots removed from {}", (Object)removedSlots.size(), (Object)currentPartition.getMasterAddr());
                continue block0;
            }
        }
    }

    @Override
    public int calcSlot(String key) {
        if (key == null) {
            return 0;
        }
        int start = key.indexOf(123);
        if (start != -1) {
            int end = key.indexOf(125);
            key = key.substring(start + 1, end);
        }
        int result = CRC16.crc16(key.getBytes()) % 16384;
        this.log.debug("slot {} for {}", (Object)result, (Object)key);
        return result;
    }

    private Collection<ClusterPartition> parsePartitions(List<ClusterNodeInfo> nodes) {
        HashMap<String, ClusterPartition> partitions = new HashMap<String, ClusterPartition>();
        for (ClusterNodeInfo clusterNodeInfo : nodes) {
            ClusterPartition partition;
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.NOADDR)) continue;
            String id = clusterNodeInfo.getNodeId();
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.SLAVE)) {
                id = clusterNodeInfo.getSlaveOf();
            }
            if ((partition = (ClusterPartition)partitions.get(id)) == null) {
                partition = new ClusterPartition(id);
                partitions.put(id, partition);
            }
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.FAIL)) {
                if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.SLAVE)) {
                    partition.addFailedSlaveAddress(clusterNodeInfo.getAddress());
                } else {
                    partition.setMasterFail(true);
                }
            }
            if (clusterNodeInfo.containsFlag(ClusterNodeInfo.Flag.SLAVE)) {
                partition.addSlaveAddress(clusterNodeInfo.getAddress());
                continue;
            }
            partition.addSlotRanges(clusterNodeInfo.getSlotRanges());
            partition.setMasterAddress(clusterNodeInfo.getAddress());
        }
        return partitions.values();
    }

    @Override
    public void shutdown() {
        this.monitorFuture.cancel(true);
        super.shutdown();
        for (RedisConnection connection : this.nodeConnections.values()) {
            connection.getRedisClient().shutdown();
        }
    }

    private HashSet<ClusterPartition> getLastPartitions() {
        return new HashSet<ClusterPartition>(this.lastPartitions.values());
    }

    @Override
    public URI getLastClusterNode() {
        return this.lastClusterNode;
    }

    @Override
    public boolean isClusterMode() {
        return true;
    }
}

