/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatchers;

public interface FieldTransformer {
    public FieldDescription transform(TypeDescription var1, FieldDescription var2);

    public static class Compound
    implements FieldTransformer {
        private final List<? extends FieldTransformer> fieldTransformers;

        public Compound(FieldTransformer ... fieldTransformer) {
            this(Arrays.asList(fieldTransformer));
        }

        public Compound(List<? extends FieldTransformer> fieldTransformers) {
            this.fieldTransformers = fieldTransformers;
        }

        @Override
        public FieldDescription transform(TypeDescription instrumentedType, FieldDescription fieldDescription) {
            FieldDescription transformed = fieldDescription;
            for (FieldTransformer fieldTransformer : this.fieldTransformers) {
                transformed = fieldTransformer.transform(instrumentedType, transformed);
            }
            return transformed;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldTransformers.equals(((Compound)other).fieldTransformers);
        }

        public int hashCode() {
            return this.fieldTransformers.hashCode();
        }

        public String toString() {
            return "FieldTransformer.Compound{fieldTransformers=" + this.fieldTransformers + '}';
        }
    }

    public static class Simple
    implements FieldTransformer {
        private final TokenTransformer tokenTransformer;

        public Simple(TokenTransformer tokenTransformer) {
            this.tokenTransformer = tokenTransformer;
        }

        public static FieldTransformer withModifiers(ModifierContributor.ForField ... modifierContributor) {
            return new Simple(new TokenTransformer.ForModifierTransformation(Arrays.asList(modifierContributor)));
        }

        @Override
        public FieldDescription transform(TypeDescription instrumentedType, FieldDescription fieldDescription) {
            return new TransformedField(fieldDescription.getDeclaringType(), this.tokenTransformer.transform((FieldDescription.Token)fieldDescription.asToken(ElementMatchers.is(instrumentedType))), (FieldDescription.InDefinedShape)fieldDescription.asDefined());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.tokenTransformer.equals(((Simple)other).tokenTransformer);
        }

        public int hashCode() {
            return this.tokenTransformer.hashCode();
        }

        public String toString() {
            return "FieldTransformer.Simple{tokenTransformer=" + this.tokenTransformer + '}';
        }

        protected static class TransformedField
        extends FieldDescription.AbstractBase {
            private final TypeDefinition declaringType;
            private final FieldDescription.Token token;
            private final FieldDescription.InDefinedShape fieldDescription;

            protected TransformedField(TypeDefinition declaringType, FieldDescription.Token token, FieldDescription.InDefinedShape fieldDescription) {
                this.declaringType = declaringType;
                this.token = token;
                this.fieldDescription = fieldDescription;
            }

            @Override
            public TypeDescription.Generic getType() {
                return this.token.getType().accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return this.token.getAnnotations();
            }

            @Override
            public TypeDefinition getDeclaringType() {
                return this.declaringType;
            }

            @Override
            public int getModifiers() {
                return this.token.getModifiers();
            }

            @Override
            public FieldDescription.InDefinedShape asDefined() {
                return this.fieldDescription;
            }

            @Override
            public String getName() {
                return this.token.getName();
            }
        }

        public static interface TokenTransformer {
            public FieldDescription.Token transform(FieldDescription.Token var1);

            public static class ForModifierTransformation
            implements TokenTransformer {
                private final List<? extends ModifierContributor.ForField> modifierContributors;

                public ForModifierTransformation(List<? extends ModifierContributor.ForField> modifierContributors) {
                    this.modifierContributors = modifierContributors;
                }

                @Override
                public FieldDescription.Token transform(FieldDescription.Token token) {
                    return new FieldDescription.Token(token.getName(), ModifierContributor.Resolver.of(this.modifierContributors).resolve(token.getModifiers()), token.getType(), token.getAnnotations());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.modifierContributors.equals(((ForModifierTransformation)other).modifierContributors);
                }

                public int hashCode() {
                    return this.modifierContributors.hashCode();
                }

                public String toString() {
                    return "FieldTransformer.Simple.TokenTransformer.ForModifierTransformation{modifierContributors=" + this.modifierContributors + '}';
                }
            }
        }
    }

    public static enum NoOp implements FieldTransformer
    {
        INSTANCE;


        @Override
        public FieldDescription transform(TypeDescription instrumentedType, FieldDescription fieldDescription) {
            return fieldDescription;
        }

        public String toString() {
            return "FieldTransformer.NoOp." + this.name();
        }
    }
}

