/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import reactor.core.support.Exceptions;
import reactor.fn.Consumer;
import reactor.fn.Pausable;
import reactor.fn.timer.Timer;
import reactor.rx.Stream;
import reactor.rx.subscription.PushSubscription;

public final class SingleTimerStream
extends Stream<Long> {
    private final long delay;
    private final TimeUnit unit;
    private final Timer timer;

    public SingleTimerStream(long delay, TimeUnit unit, Timer timer) {
        this.delay = delay >= 0L ? delay : 0L;
        this.unit = unit != null ? unit : TimeUnit.SECONDS;
        this.timer = timer;
    }

    @Override
    public void subscribe(Subscriber<? super Long> subscriber) {
        try {
            subscriber.onSubscribe(new TimerSubscription(this, subscriber));
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            subscriber.onError(throwable);
        }
    }

    @Override
    public String toString() {
        return "delay=" + this.delay + " " + (Object)((Object)this.unit);
    }

    private class TimerSubscription
    extends PushSubscription<Long> {
        final Pausable registration;

        public TimerSubscription(Stream<Long> publisher, Subscriber<? super Long> subscriber) {
            super(publisher, subscriber);
            this.registration = SingleTimerStream.this.timer.submit(new Consumer<Long>(){

                @Override
                public void accept(Long aLong) {
                    TimerSubscription.this.subscriber.onNext(0L);
                    TimerSubscription.this.subscriber.onComplete();
                }
            }, SingleTimerStream.this.delay, SingleTimerStream.this.unit);
        }

        @Override
        public void cancel() {
            this.registration.cancel();
            super.cancel();
        }
    }
}

