/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import io.netty.channel.EventLoopGroup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.ConfigSupport;
import org.redisson.config.ElasticacheServersConfig;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;

public class Config {
    private SentinelServersConfig sentinelServersConfig;
    private MasterSlaveServersConfig masterSlaveServersConfig;
    private SingleServerConfig singleServerConfig;
    private ClusterServersConfig clusterServersConfig;
    private ElasticacheServersConfig elasticacheServersConfig;
    private int threads = 0;
    private Codec codec;
    private boolean useLinuxNativeEpoll;
    private EventLoopGroup eventLoopGroup;

    public Config() {
    }

    public Config(Config oldConf) {
        this.setUseLinuxNativeEpoll(oldConf.isUseLinuxNativeEpoll());
        this.setEventLoopGroup(oldConf.getEventLoopGroup());
        if (oldConf.getCodec() == null) {
            oldConf.setCodec(new JsonJacksonCodec());
        }
        this.setThreads(oldConf.getThreads());
        this.setCodec(oldConf.getCodec());
        this.setEventLoopGroup(oldConf.getEventLoopGroup());
        if (oldConf.getSingleServerConfig() != null) {
            this.setSingleServerConfig(new SingleServerConfig(oldConf.getSingleServerConfig()));
        }
        if (oldConf.getMasterSlaveServersConfig() != null) {
            this.setMasterSlaveServersConfig(new MasterSlaveServersConfig(oldConf.getMasterSlaveServersConfig()));
        }
        if (oldConf.getSentinelServersConfig() != null) {
            this.setSentinelServersConfig(new SentinelServersConfig(oldConf.getSentinelServersConfig()));
        }
        if (oldConf.getClusterServersConfig() != null) {
            this.setClusterServersConfig(new ClusterServersConfig(oldConf.getClusterServersConfig()));
        }
        if (oldConf.getElasticacheServersConfig() != null) {
            this.setElasticacheServersConfig(new ElasticacheServersConfig(oldConf.getElasticacheServersConfig()));
        }
    }

    public Config setCodec(Codec codec) {
        this.codec = codec;
        return this;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public ClusterServersConfig useClusterServers() {
        return this.useClusterServers(new ClusterServersConfig());
    }

    ClusterServersConfig useClusterServers(ClusterServersConfig config) {
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkSingleServerConfig();
        this.checkElasticacheServersConfig();
        if (this.clusterServersConfig == null) {
            this.clusterServersConfig = config;
        }
        return this.clusterServersConfig;
    }

    ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        this.clusterServersConfig = clusterServersConfig;
    }

    public ElasticacheServersConfig useElasticacheServers() {
        return this.useElasticacheServers(new ElasticacheServersConfig());
    }

    ElasticacheServersConfig useElasticacheServers(ElasticacheServersConfig config) {
        this.checkClusterServersConfig();
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkSingleServerConfig();
        if (this.elasticacheServersConfig == null) {
            this.elasticacheServersConfig = new ElasticacheServersConfig();
        }
        return this.elasticacheServersConfig;
    }

    ElasticacheServersConfig getElasticacheServersConfig() {
        return this.elasticacheServersConfig;
    }

    void setElasticacheServersConfig(ElasticacheServersConfig elasticacheServersConfig) {
        this.elasticacheServersConfig = elasticacheServersConfig;
    }

    public SingleServerConfig useSingleServer() {
        return this.useSingleServer(new SingleServerConfig());
    }

    SingleServerConfig useSingleServer(SingleServerConfig config) {
        this.checkClusterServersConfig();
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkElasticacheServersConfig();
        if (this.singleServerConfig == null) {
            this.singleServerConfig = config;
        }
        return this.singleServerConfig;
    }

    SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    void setSingleServerConfig(SingleServerConfig singleConnectionConfig) {
        this.singleServerConfig = singleConnectionConfig;
    }

    public SentinelServersConfig useSentinelServers() {
        return this.useSentinelServers(new SentinelServersConfig());
    }

    public SentinelServersConfig useSentinelServers(SentinelServersConfig sentinelServersConfig) {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkMasterSlaveServersConfig();
        this.checkElasticacheServersConfig();
        if (this.sentinelServersConfig == null) {
            this.sentinelServersConfig = sentinelServersConfig;
        }
        return this.sentinelServersConfig;
    }

    SentinelServersConfig getSentinelServersConfig() {
        return this.sentinelServersConfig;
    }

    void setSentinelServersConfig(SentinelServersConfig sentinelConnectionConfig) {
        this.sentinelServersConfig = sentinelConnectionConfig;
    }

    public MasterSlaveServersConfig useMasterSlaveServers() {
        return this.useMasterSlaveServers(new MasterSlaveServersConfig());
    }

    public MasterSlaveServersConfig useMasterSlaveServers(MasterSlaveServersConfig config) {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkSentinelServersConfig();
        this.checkElasticacheServersConfig();
        if (this.masterSlaveServersConfig == null) {
            this.masterSlaveServersConfig = config;
        }
        return this.masterSlaveServersConfig;
    }

    MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return this.masterSlaveServersConfig;
    }

    void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveConnectionConfig) {
        this.masterSlaveServersConfig = masterSlaveConnectionConfig;
    }

    public boolean isClusterConfig() {
        return this.clusterServersConfig != null;
    }

    public int getThreads() {
        return this.threads;
    }

    public Config setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    private void checkClusterServersConfig() {
        if (this.clusterServersConfig != null) {
            throw new IllegalStateException("cluster servers config already used!");
        }
    }

    private void checkSentinelServersConfig() {
        if (this.sentinelServersConfig != null) {
            throw new IllegalStateException("sentinel servers config already used!");
        }
    }

    private void checkMasterSlaveServersConfig() {
        if (this.masterSlaveServersConfig != null) {
            throw new IllegalStateException("master/slave servers already used!");
        }
    }

    private void checkSingleServerConfig() {
        if (this.singleServerConfig != null) {
            throw new IllegalStateException("single server config already used!");
        }
    }

    private void checkElasticacheServersConfig() {
        if (this.elasticacheServersConfig != null) {
            throw new IllegalStateException("elasticache replication group servers config already used!");
        }
    }

    public Config setUseLinuxNativeEpoll(boolean useLinuxNativeEpoll) {
        this.useLinuxNativeEpoll = useLinuxNativeEpoll;
        return this;
    }

    public boolean isUseLinuxNativeEpoll() {
        return this.useLinuxNativeEpoll;
    }

    public Config setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public static Config fromJSON(String content) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(content, Config.class);
    }

    public static Config fromJSON(InputStream inputStream) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(inputStream, Config.class);
    }

    public static Config fromJSON(File file) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(file, Config.class);
    }

    public static Config fromJSON(URL url) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(url, Config.class);
    }

    public static Config fromJSON(Reader reader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(reader, Config.class);
    }

    public String toJSON() throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.toJSON(this);
    }

    public static Config fromYAML(String content) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(content, Config.class);
    }

    public static Config fromYAML(InputStream inputStream) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(inputStream, Config.class);
    }

    public static Config fromYAML(File file) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(file, Config.class);
    }

    public static Config fromYAML(URL url) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(url, Config.class);
    }

    public static Config fromYAML(Reader reader) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(reader, Config.class);
    }

    public String toYAML() throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.toYAML(this);
    }
}

