/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedisClientResult;
import org.redisson.RedissonShutdownException;
import org.redisson.SlotCallback;
import org.redisson.api.RFuture;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.AsyncDetails;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAsyncService
implements CommandAsyncExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandAsyncService.class);
    final ConnectionManager connectionManager;

    public CommandAsyncService(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public <V> V get(RFuture<V> future) {
        final CountDownLatch l = new CountDownLatch(1);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                l.countDown();
            }
        });
        boolean interrupted = false;
        while (!future.isDone()) {
            try {
                l.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (future.isSuccess()) {
            return future.getNow();
        }
        throw this.convertException(future);
    }

    @Override
    public boolean await(RFuture<?> future, long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        final CountDownLatch l = new CountDownLatch(1);
        future.addListener(new FutureListener<Object>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                l.countDown();
            }
        });
        return l.await(timeout, timeoutUnit);
    }

    @Override
    public <T, R> RFuture<R> readAsync(InetSocketAddress client, MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(true, new NodeSource(entry, client), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(InetSocketAddress client, String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        int slot = this.connectionManager.calcSlot(key);
        this.async(true, new NodeSource(slot, client), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<Collection<R>> readAllAsync(RedisCommand<T> command, Object ... params) {
        final RPromise<Collection<R>> mainPromise = this.connectionManager.newPromise();
        Set<MasterSlaveEntry> nodes = this.connectionManager.getEntrySet();
        final ArrayList results = new ArrayList();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        FutureListener listener = new FutureListener<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<R> future) throws Exception {
                if (!future.isSuccess()) {
                    mainPromise.tryFailure(future.cause());
                    return;
                }
                Object result = future.getNow();
                if (result instanceof Collection) {
                    List list = results;
                    synchronized (list) {
                        results.addAll((Collection)result);
                    }
                }
                List list = results;
                synchronized (list) {
                    results.add(result);
                }
                if (counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.setSuccess(results);
                }
            }
        };
        for (MasterSlaveEntry entry : nodes) {
            RPromise promise = this.connectionManager.newPromise();
            promise.addListener(listener);
            this.async(true, new NodeSource(entry), this.connectionManager.getCodec(), command, params, promise, 0);
        }
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readRandomAsync(RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        ArrayList<MasterSlaveEntry> nodes = new ArrayList<MasterSlaveEntry>(this.connectionManager.getEntrySet());
        Collections.shuffle(nodes);
        this.retryReadRandomAsync(command, mainPromise, nodes, params);
        return mainPromise;
    }

    private <R, T> void retryReadRandomAsync(final RedisCommand<T> command, final RPromise<R> mainPromise, final List<MasterSlaveEntry> nodes, final Object ... params) {
        RPromise attemptPromise = this.connectionManager.newPromise();
        attemptPromise.addListener(new FutureListener<R>(){

            @Override
            public void operationComplete(Future<R> future) throws Exception {
                if (future.isSuccess()) {
                    if (future.getNow() == null) {
                        if (nodes.isEmpty()) {
                            mainPromise.setSuccess(null);
                        } else {
                            CommandAsyncService.this.retryReadRandomAsync(command, mainPromise, nodes, params);
                        }
                    } else {
                        mainPromise.setSuccess(future.getNow());
                    }
                } else {
                    mainPromise.setFailure(future.cause());
                }
            }
        });
        MasterSlaveEntry entry = nodes.remove(0);
        this.async(true, new NodeSource(entry), this.connectionManager.getCodec(), command, params, attemptPromise, 0);
    }

    @Override
    public <T> RFuture<Void> writeAllAsync(RedisCommand<T> command, Object ... params) {
        return this.writeAllAsync(command, null, params);
    }

    @Override
    public <R, T> RFuture<R> writeAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(false, command, callback, params);
    }

    @Override
    public <R, T> RFuture<R> readAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(true, command, callback, params);
    }

    private <T, R> RFuture<R> allAsync(boolean readOnlyMode, RedisCommand<T> command, final SlotCallback<T, R> callback, Object ... params) {
        final RPromise mainPromise = this.connectionManager.newPromise();
        Set<MasterSlaveEntry> nodes = this.connectionManager.getEntrySet();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        FutureListener listener = new FutureListener<T>(){

            @Override
            public void operationComplete(Future<T> future) throws Exception {
                if (!future.isSuccess()) {
                    mainPromise.tryFailure(future.cause());
                    return;
                }
                if (callback != null) {
                    callback.onSlotResult(future.getNow());
                }
                if (counter.decrementAndGet() == 0) {
                    if (callback != null) {
                        mainPromise.setSuccess(callback.onFinish());
                    } else {
                        mainPromise.setSuccess(null);
                    }
                }
            }
        };
        for (MasterSlaveEntry entry : nodes) {
            RPromise promise = this.connectionManager.newPromise();
            promise.addListener(listener);
            this.async(readOnlyMode, new NodeSource(entry), this.connectionManager.getCodec(), command, params, promise, 0);
        }
        return mainPromise;
    }

    @Override
    public <V> RedisException convertException(RFuture<V> future) {
        return future.cause() instanceof RedisException ? (RedisException)future.cause() : new RedisException("Unexpected exception while processing command", future.cause());
    }

    private NodeSource getNodeSource(String key) {
        int slot = this.connectionManager.calcSlot(key);
        MasterSlaveEntry entry = this.connectionManager.getEntry(slot);
        return new NodeSource(entry);
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(true, source, codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(true, new NodeSource(entry), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(Integer slot, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(true, new NodeSource(slot), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(false, new NodeSource(entry), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(Integer slot, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(false, new NodeSource(slot), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.readAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(Integer slot, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(slot), true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(InetSocketAddress client, String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        int slot = this.connectionManager.calcSlot(key);
        return this.evalAsync(new NodeSource(slot, client), true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, false, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), false, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(Integer slot, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(slot), false, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        return this.evalAllAsync(false, command, callback, script, keys, params);
    }

    public <T, R> RFuture<R> evalAllAsync(boolean readOnlyMode, RedisCommand<T> command, final SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        final RPromise mainPromise = this.connectionManager.newPromise();
        Set<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        final AtomicInteger counter = new AtomicInteger(entries.size());
        FutureListener listener = new FutureListener<T>(){

            @Override
            public void operationComplete(Future<T> future) throws Exception {
                if (!future.isSuccess()) {
                    mainPromise.tryFailure(future.cause());
                    return;
                }
                callback.onSlotResult(future.getNow());
                if (counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.setSuccess(callback.onFinish());
                }
            }
        };
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        for (MasterSlaveEntry entry : entries) {
            RPromise promise = this.connectionManager.newPromise();
            promise.addListener(listener);
            this.async(readOnlyMode, new NodeSource(entry), this.connectionManager.getCodec(), command, args.toArray(), promise, 0);
        }
        return mainPromise;
    }

    private <T, R> RFuture<R> evalAsync(NodeSource nodeSource, boolean readOnlyMode, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        this.async(readOnlyMode, nodeSource, codec, evalCommandType, args.toArray(), mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.writeAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(false, source, codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    protected <V, R> void async(boolean readOnlyMode, final NodeSource source, Codec codec, final RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, int attempt) {
        if (mainPromise.isCancelled()) {
            return;
        }
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            mainPromise.setFailure(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        RPromise attemptPromise = this.connectionManager.newPromise();
        final RFuture<RedisConnection> connectionFuture = readOnlyMode ? this.connectionManager.connectionReadOp(source, command) : this.connectionManager.connectionWriteOp(source, command);
        final AsyncDetails details = AsyncDetails.acquire();
        details.init(connectionFuture, attemptPromise, readOnlyMode, source, codec, command, params, mainPromise, attempt);
        TimerTask retryTimerTask = new TimerTask(){

            @Override
            public void run(Timeout t) throws Exception {
                ChannelFuture writeFuture;
                if (details.getAttemptPromise().isDone()) {
                    return;
                }
                if (details.getConnectionFuture().cancel(false)) {
                    CommandAsyncService.this.connectionManager.getShutdownLatch().release();
                } else if (details.getConnectionFuture().isSuccess() && (writeFuture = details.getWriteFuture()) != null && !writeFuture.cancel(false) && writeFuture.isSuccess()) {
                    return;
                }
                if (details.getMainPromise().isCancelled()) {
                    if (details.getAttemptPromise().cancel(false)) {
                        AsyncDetails.release(details);
                    }
                    return;
                }
                if (details.getAttempt() == CommandAsyncService.this.connectionManager.getConfig().getRetryAttempts()) {
                    if (details.getException() == null) {
                        details.setException(new RedisTimeoutException("Command execution timeout for command: " + command + " with params: " + Arrays.toString(details.getParams())));
                    }
                    details.getAttemptPromise().tryFailure(details.getException());
                    return;
                }
                if (!details.getAttemptPromise().cancel(false)) {
                    return;
                }
                int count = details.getAttempt() + 1;
                if (log.isDebugEnabled()) {
                    log.debug("attempt {} for command {} and params {}", count, details.getCommand(), Arrays.toString(details.getParams()));
                }
                CommandAsyncService.this.async(details.isReadOnlyMode(), details.getSource(), details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), count);
                AsyncDetails.release(details);
            }
        };
        Timeout timeout = this.connectionManager.newTimeout(retryTimerTask, this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
        connectionFuture.addListener(new FutureListener<RedisConnection>(){

            @Override
            public void operationComplete(Future<RedisConnection> connFuture) throws Exception {
                if (connFuture.isCancelled()) {
                    return;
                }
                if (!connFuture.isSuccess()) {
                    CommandAsyncService.this.connectionManager.getShutdownLatch().release();
                    details.setException(CommandAsyncService.this.convertException(connectionFuture));
                    return;
                }
                if (details.getAttemptPromise().isDone() || details.getMainPromise().isDone()) {
                    CommandAsyncService.this.releaseConnection(source, connectionFuture, details.isReadOnlyMode(), details.getAttemptPromise(), details);
                    return;
                }
                final RedisConnection connection = connFuture.getNow();
                if (details.getSource().getRedirect() == NodeSource.Redirect.ASK) {
                    ArrayList list = new ArrayList(2);
                    RPromise promise = CommandAsyncService.this.connectionManager.newPromise();
                    list.add(new CommandData(promise, details.getCodec(), RedisCommands.ASKING, new Object[0]));
                    list.add(new CommandData(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
                    RPromise<Void> main = CommandAsyncService.this.connectionManager.newPromise();
                    ChannelFuture future = connection.send(new CommandsData(main, list));
                    details.setWriteFuture(future);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("aquired connection for command {} and params {} from slot {} using node {}", details.getCommand(), Arrays.toString(details.getParams()), details.getSource(), connection.getRedisClient().getAddr());
                    }
                    ChannelFuture future = connection.send(new CommandData(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
                    details.setWriteFuture(future);
                }
                details.getWriteFuture().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        CommandAsyncService.this.checkWriteFuture(details, connection);
                    }
                });
                CommandAsyncService.this.releaseConnection(source, connectionFuture, details.isReadOnlyMode(), details.getAttemptPromise(), details);
            }
        });
        attemptPromise.addListener(new FutureListener<R>(){

            @Override
            public void operationComplete(Future<R> future) throws Exception {
                CommandAsyncService.this.checkAttemptFuture(source, details, future);
            }
        });
    }

    private <V, R> void checkWriteFuture(final AsyncDetails<V, R> details, final RedisConnection connection) {
        ChannelFuture future = details.getWriteFuture();
        if (details.getAttemptPromise().isDone() || future.isCancelled()) {
            return;
        }
        if (!future.isSuccess()) {
            details.setException(new WriteRedisConnectionException("Can't write command: " + details.getCommand() + ", params: " + Arrays.toString(details.getParams()) + " to channel: " + future.channel(), future.cause()));
            return;
        }
        details.getTimeout().cancel();
        long timeoutTime = this.connectionManager.getConfig().getTimeout();
        if (QueueCommand.TIMEOUTLESS_COMMANDS.contains(details.getCommand().getName())) {
            Long popTimeout = Long.valueOf(details.getParams()[details.getParams().length - 1].toString());
            this.handleBlockingOperations(details, connection, popTimeout);
            if (popTimeout == 0L) {
                return;
            }
            timeoutTime += popTimeout * 1000L;
            timeoutTime += 1000L;
        }
        final long timeoutAmount = timeoutTime;
        TimerTask timeoutTask = new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                details.getAttemptPromise().tryFailure(new RedisTimeoutException("Redis server response timeout (" + timeoutAmount + " ms) occured for command: " + details.getCommand() + " with params: " + Arrays.toString(details.getParams()) + " channel: " + connection.getChannel()));
            }
        };
        Timeout timeout = this.connectionManager.newTimeout(timeoutTask, timeoutTime, TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, V> void handleBlockingOperations(final AsyncDetails<V, R> details, final RedisConnection connection, Long popTimeout) {
        Timeout scheduledFuture;
        final FutureListener<Boolean> listener = new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                details.getMainPromise().tryFailure(new RedissonShutdownException("Redisson is shutdown"));
            }
        };
        final AtomicBoolean canceledByScheduler = new AtomicBoolean();
        if (popTimeout != 0L) {
            final Channel orignalChannel = connection.getChannel();
            scheduledFuture = this.connectionManager.newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    if (orignalChannel == connection.getChannel() && connection.isActive()) {
                        return;
                    }
                    canceledByScheduler.set(true);
                    details.getAttemptPromise().trySuccess(null);
                }
            }, popTimeout, TimeUnit.SECONDS);
        } else {
            scheduledFuture = null;
        }
        details.getMainPromise().addListener(new FutureListener<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<R> future) throws Exception {
                if (scheduledFuture != null) {
                    scheduledFuture.cancel();
                }
                FutureListener futureListener = listener;
                synchronized (futureListener) {
                    CommandAsyncService.this.connectionManager.getShutdownPromise().removeListener(listener);
                }
                if (future.isCancelled() && details.getAttemptPromise().cancel(true) || canceledByScheduler.get()) {
                    connection.forceFastReconnectAsync();
                    return;
                }
                if (future.cause() instanceof RedissonShutdownException) {
                    details.getAttemptPromise().tryFailure(future.cause());
                }
            }
        });
        FutureListener<Boolean> futureListener = listener;
        synchronized (futureListener) {
            if (!details.getMainPromise().isDone()) {
                this.connectionManager.getShutdownPromise().addListener(listener);
            }
        }
    }

    protected <V, R> void releaseConnection(final NodeSource source, final RFuture<RedisConnection> connectionFuture, final boolean isReadOnly, RPromise<R> attemptPromise, final AsyncDetails<V, R> details) {
        attemptPromise.addListener(new FutureListener<R>(){

            @Override
            public void operationComplete(Future<R> future) throws Exception {
                if (!connectionFuture.isSuccess()) {
                    return;
                }
                RedisConnection connection = (RedisConnection)connectionFuture.getNow();
                CommandAsyncService.this.connectionManager.getShutdownLatch().release();
                if (isReadOnly) {
                    CommandAsyncService.this.connectionManager.releaseRead(source, connection);
                } else {
                    CommandAsyncService.this.connectionManager.releaseWrite(source, connection);
                }
                if (log.isDebugEnabled()) {
                    log.debug("connection released for command {} and params {} from slot {} using connection {}", details.getCommand(), Arrays.toString(details.getParams()), details.getSource(), connection);
                }
            }
        });
    }

    private <R, V> void checkAttemptFuture(NodeSource source, AsyncDetails<V, R> details, Future<R> future) {
        details.getTimeout().cancel();
        if (future.isCancelled()) {
            return;
        }
        if (future.cause() instanceof RedisMovedException) {
            RedisMovedException ex = (RedisMovedException)future.cause();
            this.async(details.isReadOnlyMode(), new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.MOVED), details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), details.getAttempt());
            AsyncDetails.release(details);
            return;
        }
        if (future.cause() instanceof RedisAskException) {
            RedisAskException ex = (RedisAskException)future.cause();
            this.async(details.isReadOnlyMode(), new NodeSource(ex.getSlot(), ex.getAddr(), NodeSource.Redirect.ASK), details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), details.getAttempt());
            AsyncDetails.release(details);
            return;
        }
        if (future.cause() instanceof RedisLoadingException) {
            this.async(details.isReadOnlyMode(), source, details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), details.getAttempt());
            AsyncDetails.release(details);
            return;
        }
        if (future.isSuccess()) {
            R res = future.getNow();
            if (res instanceof RedisClientResult) {
                InetSocketAddress addr = source.getAddr();
                if (addr == null) {
                    addr = details.getConnectionFuture().getNow().getRedisClient().getAddr();
                }
                ((RedisClientResult)res).setRedisClient(addr);
            }
            details.getMainPromise().trySuccess(res);
        } else {
            details.getMainPromise().tryFailure(future.cause());
        }
        AsyncDetails.release(details);
    }
}

