/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonDeque;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;

public class RedissonBlockingDeque<V>
extends RedissonDeque<V>
implements RBlockingDeque<V> {
    private final RedissonBlockingQueue<V> blockingQueue;

    protected RedissonBlockingDeque(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.blockingQueue = new RedissonBlockingQueue(commandExecutor, name);
    }

    protected RedissonBlockingDeque(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.blockingQueue = new RedissonBlockingQueue(codec, commandExecutor, name);
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        final RPromise<Void> result = this.commandExecutor.getConnectionManager().newPromise();
        this.offerAsync(e).addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setFailure(future.cause());
                    return;
                }
                result.setSuccess(null);
            }
        });
        return result;
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.get(this.putAsync(e));
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public RFuture<V> takeAsync() {
        return this.blockingQueue.takeAsync();
    }

    @Override
    public V take() throws InterruptedException {
        return this.blockingQueue.take();
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        return this.blockingQueue.pollAsync(timeout, unit);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.blockingQueue.poll(timeout, unit);
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.blockingQueue.pollFromAny(timeout, unit, new String[0]);
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.blockingQueue.pollFromAnyAsync(timeout, unit, new String[0]);
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        return this.blockingQueue.pollLastAndOfferFirstToAsync(queueName, timeout, unit);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.blockingQueue.pollLastAndOfferFirstTo(queueName, timeout, unit);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.blockingQueue.drainTo(c);
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        return this.blockingQueue.drainToAsync(c);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        return this.blockingQueue.drainTo(c, maxElements);
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        return this.blockingQueue.drainToAsync(c, maxElements);
    }

    @Override
    public RFuture<Void> putFirstAsync(V e) {
        return this.addFirstAsync(e);
    }

    @Override
    public RFuture<Void> putLastAsync(V e) {
        return this.addLastAsync(e);
    }

    @Override
    public void putFirst(V e) throws InterruptedException {
        this.addFirst(e);
    }

    @Override
    public void putLast(V e) throws InterruptedException {
        this.addLast(e);
    }

    @Override
    public boolean offerFirst(V e, long timeout, TimeUnit unit) throws InterruptedException {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(V e, long timeout, TimeUnit unit) throws InterruptedException {
        this.addLast(e);
        return true;
    }

    @Override
    public V takeFirst() throws InterruptedException {
        RFuture<V> res = this.takeFirstAsync();
        return res.await().getNow();
    }

    @Override
    public RFuture<V> takeFirstAsync() {
        return this.takeAsync();
    }

    @Override
    public RFuture<V> takeLastAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BRPOP_VALUE, this.getName(), 0);
    }

    @Override
    public V takeLast() throws InterruptedException {
        RFuture<V> res = this.takeLastAsync();
        return res.await().getNow();
    }

    @Override
    public RFuture<V> pollFirstAsync(long timeout, TimeUnit unit) {
        return this.pollAsync(timeout, unit);
    }

    @Override
    public V pollFirstFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        RFuture<V> res = this.pollFirstFromAnyAsync(timeout, unit, queueNames);
        return res.await().getNow();
    }

    @Override
    public RFuture<V> pollFirstFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        return this.pollFromAnyAsync(timeout, unit, queueNames);
    }

    @Override
    public V pollLastFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        RFuture<V> res = this.pollLastFromAnyAsync(timeout, unit, queueNames);
        return res.await().getNow();
    }

    @Override
    public RFuture<V> pollLastFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        ArrayList<Object> params = new ArrayList<Object>(queueNames.length + 1);
        params.add(this.getName());
        for (String name : queueNames) {
            params.add(name);
        }
        params.add(unit.toSeconds(timeout));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BRPOP_VALUE, params.toArray());
    }

    @Override
    public V pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        RFuture<V> res = this.pollFirstAsync(timeout, unit);
        return res.await().getNow();
    }

    @Override
    public RFuture<V> pollLastAsync(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BRPOP_VALUE, this.getName(), unit.toSeconds(timeout));
    }

    @Override
    public V pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        RFuture<V> res = this.pollLastAsync(timeout, unit);
        return res.await().getNow();
    }
}

