/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.redisson.RedissonList;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import reactor.rx.Stream;
import reactor.rx.subscription.ReactiveSubscription;

public class RedissonListReactive<V> {
    private final RedissonList<V> instance;

    public RedissonListReactive(CommandReactiveExecutor commandExecutor, String name) {
        this.instance = new RedissonList(commandExecutor, name, null);
    }

    public RedissonListReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this.instance = new RedissonList(codec, commandExecutor, name, null);
    }

    public Publisher<V> descendingIterator() {
        return this.iterator(-1, false);
    }

    public Publisher<V> iterator() {
        return this.iterator(0, true);
    }

    public Publisher<V> descendingIterator(int startIndex) {
        return this.iterator(startIndex, false);
    }

    public Publisher<V> iterator(int startIndex) {
        return this.iterator(startIndex, true);
    }

    private Publisher<V> iterator(final int startIndex, final boolean forward) {
        return new Stream<V>(){

            @Override
            public void subscribe(Subscriber<? super V> t) {
                t.onSubscribe(new ReactiveSubscription<V>(this, t){
                    private int currentIndex;
                    {
                        this.currentIndex = startIndex;
                    }

                    @Override
                    protected void onRequest(final long n) {
                        final 1 m = this;
                        RedissonListReactive.this.instance.getAsync(this.currentIndex).addListener(new FutureListener<V>(){

                            @Override
                            public void operationComplete(Future<V> future) throws Exception {
                                if (!future.isSuccess()) {
                                    m.onError(future.cause());
                                    return;
                                }
                                Object value = future.getNow();
                                if (value != null) {
                                    m.onNext(value);
                                    if (forward) {
                                        currentIndex++;
                                    } else {
                                        currentIndex--;
                                    }
                                }
                                if (value == null) {
                                    m.onComplete();
                                    return;
                                }
                                if (n - 1L == 0L) {
                                    return;
                                }
                                this.onRequest(n - 1L);
                            }
                        });
                    }
                });
            }
        };
    }

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(){

            @Override
            public RFuture<Boolean> add(Object o) {
                return RedissonListReactive.this.instance.addAsync(o);
            }
        }.addAll(c);
    }
}

