/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.dns;

import io.netty.channel.socket.DatagramChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.SingletonDnsServerAddressStreamProvider;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.redisson.connection.dns.GroupAddressResolver;

public class MultiDnsAddressResolverGroup
extends DnsAddressResolverGroup {
    List<DnsAddressResolverGroup> groups = new ArrayList<DnsAddressResolverGroup>();

    public MultiDnsAddressResolverGroup(Class<? extends DatagramChannel> channelType, DnsServerAddressStreamProvider nameServerProvider) {
        super(channelType, nameServerProvider);
        InetSocketAddress dns;
        DnsServerAddressStream t = nameServerProvider.nameServerAddressStream("");
        InetSocketAddress firstDNS = t.next();
        do {
            dns = t.next();
            DnsAddressResolverGroup group = new DnsAddressResolverGroup(channelType, (DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dns));
            this.groups.add(group);
        } while (dns != firstDNS);
    }

    @Override
    public AddressResolver<InetSocketAddress> getResolver(EventExecutor executor) {
        ArrayList<AddressResolver<InetSocketAddress>> resolvers = new ArrayList<AddressResolver<InetSocketAddress>>();
        for (DnsAddressResolverGroup group : this.groups) {
            resolvers.add(group.getResolver(executor));
        }
        return new GroupAddressResolver(resolvers);
    }

    @Override
    public void close() {
        for (DnsAddressResolverGroup group : this.groups) {
            group.close();
        }
    }
}

