/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ObjectMapReplayDecoder
implements MultiDecoder<Map<Object, Object>> {
    private Decoder<Object> codec;
    private Convertor<?> convertor;

    public ObjectMapReplayDecoder() {
    }

    public ObjectMapReplayDecoder(Decoder<Object> codec) {
        this.codec = codec;
    }

    public ObjectMapReplayDecoder(Decoder<Object> codec, Convertor<?> convertor) {
        this.codec = codec;
        this.convertor = convertor;
    }

    @Override
    public Map<Object, Object> decode(List<Object> parts, State state) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            if (this.convertor != null) {
                result.put(this.convertor.convert(parts.get(i - 1)), parts.get(i));
                continue;
            }
            result.put(parts.get(i - 1), parts.get(i));
        }
        return result;
    }

    @Override
    public Decoder<Object> getDecoder(int paramNum, State state) {
        if (this.codec != null) {
            return this.codec;
        }
        return null;
    }
}

